/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.log;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.tentackle.log.Logger;
import org.tentackle.log.MethodStatisticsKey;
import org.tentackle.log.StatisticsResult;
import org.tentackle.misc.Duration;
import org.tentackle.reflect.ReflectionHelper;

public class MethodStatistics {
    private static final Logger LOGGER = Logger.get(MethodStatistics.class);
    private final Map<MethodStatisticsKey, StatisticsResult> stats = new HashMap<MethodStatisticsKey, StatisticsResult>();

    public synchronized void countMethodInvocation(Method method, Class<?> servicedClass, Duration duration) {
        MethodStatisticsKey key = new MethodStatisticsKey(method, servicedClass);
        StatisticsResult result = this.stats.computeIfAbsent(key, k -> new StatisticsResult());
        result.count(duration);
    }

    public void countMethodInvocation(Method method, Duration duration) {
        this.countMethodInvocation(method, null, duration);
    }

    public synchronized void logStatistics(String title, Logger.Level level, String tag, boolean clear) {
        if (!this.stats.isEmpty()) {
            if (LOGGER.isLoggable(level)) {
                try {
                    StringBuilder buf = new StringBuilder();
                    if (title == null) {
                        title = "Invocation statistics:";
                    }
                    buf.append(title);
                    for (Map.Entry<MethodStatisticsKey, StatisticsResult> entry : this.stats.entrySet()) {
                        StatisticsResult result = entry.getValue();
                        MethodStatisticsKey key = entry.getKey();
                        buf.append('\n').append(tag).append(result.getMinDuration().millisToString()).append(' ').append(result.getMaxDuration().millisToString()).append(' ').append(result.getTotalDuration().millisToString()).append(" ms / ").append(result.getCount()).append(" x ").append(ReflectionHelper.methodToString(key.getMethod()));
                        if (key.getServicedClass().equals(key.getMethod().getDeclaringClass())) continue;
                        buf.append(" for ").append(ReflectionHelper.getClassBaseName(key.getServicedClass()));
                    }
                    if (clear) {
                        buf.append("\n    (cleared)");
                    }
                    LOGGER.log(level, buf.toString(), null);
                }
                catch (RuntimeException rex) {
                    LOGGER.severe("cannot log method statistics", rex);
                }
            }
            if (clear) {
                this.stats.clear();
            }
        }
    }
}

