/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.log;

import java.lang.reflect.Method;
import java.util.Objects;

public class MethodStatisticsKey {
    private final Method method;
    private final Class<?> servicedClass;

    public MethodStatisticsKey(Method method, Class<?> servicedClass) {
        this.method = method;
        this.servicedClass = servicedClass == null ? method.getDeclaringClass() : servicedClass;
    }

    public MethodStatisticsKey(Method method) {
        this(method, null);
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getServicedClass() {
        return this.servicedClass;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.method);
        hash = 23 * hash + Objects.hashCode(this.servicedClass);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodStatisticsKey other = (MethodStatisticsKey)obj;
        if (!Objects.equals(this.method, other.method)) {
            return false;
        }
        return Objects.equals(this.servicedClass, other.servicedClass);
    }
}

