/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Canonicalizer<T> {
    private final int limit;
    private final Map<T, T> objectMap;

    public Canonicalizer(boolean threadSafe, int limit) {
        this.limit = limit;
        this.objectMap = threadSafe ? new ConcurrentHashMap() : new HashMap();
    }

    public Canonicalizer() {
        this(false, 0);
    }

    public T canonicalize(T obj) {
        T canon;
        if (obj == null) {
            return null;
        }
        if (this.limit > 0 && this.objectMap.size() > this.limit) {
            this.objectMap.clear();
        }
        return (canon = this.objectMap.putIfAbsent(obj, obj)) == null ? obj : canon;
    }

    public Collection<T> getObjects() {
        return this.objectMap.values();
    }
}

