/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class CommandLine {
    private String[] args;
    private final List<String> arguments = new ArrayList<String>();
    private final Map<String, String> options = new TreeMap<String, String>();

    public CommandLine(String[] args) {
        this.setArgs(args);
    }

    public CommandLine() {
        this(null);
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
        this.arguments.clear();
        this.options.clear();
        if (args != null) {
            for (String arg : args) {
                if (arg == null) continue;
                if (arg.startsWith("--")) {
                    String option = arg.substring(2);
                    String value = null;
                    int ndx = option.indexOf(61);
                    if (ndx > 0) {
                        value = option.substring(ndx + 1);
                        option = option.substring(0, ndx);
                    }
                    this.options.put(option, value);
                    continue;
                }
                this.arguments.add(arg);
            }
        }
    }

    public boolean isOptionSet(String option) {
        return this.options.containsKey(option);
    }

    public String getOptionValue(String option) {
        return this.options.get(option);
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public Properties getOptionsAsProperties() {
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            props.setProperty(entry.getKey(), value);
        }
        return props;
    }
}

