/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import org.tentackle.common.BMoney;
import org.tentackle.common.DMoney;
import org.tentackle.misc.FormatHelper;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.script.Script;
import org.tentackle.script.ScriptFactory;
import org.tentackle.script.ScriptRuntimeException;
import org.tentackle.script.ScriptVariable;

public class CompoundValue {
    public static final String VAR_OBJECT = "object";
    private String str;
    private Class<?> clazz;
    private Type type;
    private String constant;
    private Object constantValue;
    private String reference;
    private String staticClassName;
    private boolean negate;
    private Script script;
    private boolean scriptCached;
    private boolean scriptExecutedThreadSafe;

    public CompoundValue(String str, Class<?> clazz) {
        this.configure(str, clazz);
    }

    public CompoundValue(String str) {
        this.configure(str, null);
    }

    public CompoundValue() {
    }

    public String toString() {
        return "[" + this.type + "] " + this.str;
    }

    public boolean isScriptCached() {
        return this.scriptCached;
    }

    public void setScriptCached(boolean scriptCached) {
        this.scriptCached = scriptCached;
    }

    public boolean isScriptExecutedThreadSafe() {
        return this.scriptExecutedThreadSafe;
    }

    public void setScriptExecutedThreadSafe(boolean scriptExecutedThreadSafe) {
        this.scriptExecutedThreadSafe = scriptExecutedThreadSafe;
    }

    public void configure(String str, Class<?> clazz) {
        int length;
        this.str = str;
        this.clazz = clazz;
        this.type = null;
        this.constant = null;
        this.constantValue = null;
        this.reference = null;
        this.staticClassName = null;
        this.negate = false;
        this.script = null;
        int n = length = str == null ? 0 : str.length();
        if (length == 0) {
            throw new IllegalArgumentException("string value must not be null or empty");
        }
        char c = str.charAt(0);
        if (c == '\\') {
            if (length < 2) {
                throw new IllegalArgumentException("constant value must not be empty");
            }
            this.type = Type.CONSTANT;
            this.constant = str.substring(1);
            if (clazz == null) {
                throw new IllegalArgumentException("clazz must be set for type " + this.type);
            }
        } else {
            int ndx = str.indexOf(123);
            if ((ndx == 0 || ndx >= 2 && str.startsWith("#!")) && str.endsWith("}")) {
                this.type = Type.SCRIPT;
                try {
                    String language = str.substring(ndx == 0 ? 0 : 2, ndx);
                    String code = str.substring(ndx + 1, length - 1);
                    this.script = ScriptFactory.getInstance().createScript(language, code, this.isScriptCached(), this.isScriptExecutedThreadSafe());
                }
                catch (ScriptRuntimeException ex) {
                    throw new IllegalArgumentException("creating script '" + str + "' failed", ex);
                }
            }
            if (c == '$' || c == '!') {
                if (c == '$') {
                    if (length < 2) {
                        throw new IllegalArgumentException("reference must not be empty");
                    }
                    this.reference = str.substring(1);
                } else {
                    if (length < 3) {
                        throw new IllegalArgumentException("negated boolean reference must not be empty");
                    }
                    if (str.charAt(1) != '$') {
                        throw new IllegalArgumentException("negated boolean reference must start with !$");
                    }
                    this.reference = str.substring(2);
                    this.negate = true;
                }
                this.type = Type.REFERENCE;
                StringTokenizer stok = new StringTokenizer(this.reference, ".");
                StringBuilder classBuf = new StringBuilder();
                while (stok.hasMoreTokens()) {
                    String token = stok.nextToken();
                    if (classBuf.length() > 0) {
                        classBuf.append('.');
                    }
                    classBuf.append(token);
                    if (!Character.isUpperCase(token.charAt(0))) continue;
                    this.type = Type.STATIC_REFERENCE;
                    this.staticClassName = classBuf.toString();
                    this.reference = this.reference.substring(this.staticClassName.length() + 1);
                    break;
                }
            } else {
                this.type = Type.CONSTANT;
                this.constant = str;
            }
        }
    }

    public boolean isConfigured() {
        return this.getType() != null;
    }

    public Type getType() {
        return this.type;
    }

    public Script getScript() {
        return this.script;
    }

    public Object getConstantValue() {
        return this.constantValue;
    }

    public String getReference() {
        return this.reference;
    }

    public String getStaticClassName() {
        return this.staticClassName;
    }

    public boolean isNegate() {
        return this.negate;
    }

    public Object getValue(Object parentObject, ScriptVariable ... variables) {
        if (!this.isConfigured()) {
            throw new IllegalStateException("compound value is not configured");
        }
        switch (this.type) {
            case CONSTANT: {
                if (this.constantValue == null) {
                    this.constantValue = this.createConstantValue(this.clazz, this.constant);
                }
                return this.constantValue;
            }
            case REFERENCE: {
                if (parentObject == null) {
                    throw new IllegalArgumentException("parent must not be null for type " + this.type);
                }
                try {
                    Object value = ReflectionHelper.getValueByPath(parentObject, this.reference);
                    return this.negate ? this.negateBoolean(value) : value;
                }
                catch (RuntimeException ex) {
                    throw new IllegalArgumentException("cannot evaluate reference '" + this.reference + "'", ex);
                }
            }
            case STATIC_REFERENCE: {
                try {
                    Class<?> staticClass = Class.forName(this.staticClassName);
                    Object value = ReflectionHelper.getStaticValueByPath(staticClass, this.reference);
                    return this.negate ? this.negateBoolean(value) : value;
                }
                catch (ClassNotFoundException e1) {
                    throw new IllegalArgumentException("cannot evaluate static reference '" + this.staticClassName + "." + this.reference + "'", e1);
                }
                catch (RuntimeException e2) {
                    throw new IllegalArgumentException("cannot evaluate reference '" + this.reference + "'", e2);
                }
            }
            case SCRIPT: {
                try {
                    ScriptVariable objectVariable = new ScriptVariable(VAR_OBJECT, parentObject);
                    if (variables == null) {
                        variables = new ScriptVariable[]{objectVariable};
                    } else {
                        ScriptVariable[] newVariables = new ScriptVariable[variables.length + 1];
                        System.arraycopy(variables, 0, newVariables, 0, variables.length);
                        newVariables[variables.length] = objectVariable;
                        variables = newVariables;
                    }
                    this.script.execute(variables);
                    Object result = this.script.getResult();
                    if (this.clazz != null && result != null && !this.clazz.isAssignableFrom(result.getClass())) {
                        result = this.convertValue(this.clazz, result);
                    }
                    return result;
                }
                catch (RuntimeException ex) {
                    throw new IllegalArgumentException("evaluating script '" + this.script + "' failed", ex);
                }
            }
        }
        throw new IllegalArgumentException("unsupported validation value type");
    }

    public Object getValue(ScriptVariable ... variables) {
        return this.getValue((Object)null, variables);
    }

    public void parse(Class<?> parentObjectClass) {
        switch (this.type) {
            case CONSTANT: {
                this.createConstantValue(this.clazz, this.constant);
                break;
            }
            case REFERENCE: {
                try {
                    if (!ReflectionHelper.verifyPath(parentObjectClass, this.reference)) {
                        throw new IllegalArgumentException("'" + parentObjectClass.getName() + "." + this.reference + "' is not a valid path");
                    }
                    break;
                }
                catch (RuntimeException ex) {
                    throw new IllegalArgumentException("cannot parse reference '" + this.reference + "'", ex);
                }
            }
            case STATIC_REFERENCE: {
                try {
                    Class<?> staticClass = Class.forName(this.staticClassName);
                    if (!ReflectionHelper.verifyPath(staticClass, this.reference)) {
                        throw new IllegalArgumentException("'" + this.staticClassName + "." + this.reference + "' is not a valid path");
                    }
                    break;
                }
                catch (ClassNotFoundException e1) {
                    throw new IllegalArgumentException("cannot parse static reference '" + this.staticClassName + "." + this.reference + "'", e1);
                }
                catch (RuntimeException e2) {
                    throw new IllegalArgumentException("cannot parse reference '" + this.reference + "'", e2);
                }
            }
            case SCRIPT: {
                try {
                    this.script.parse();
                    break;
                }
                catch (ScriptRuntimeException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        }
    }

    private Boolean negateBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        throw new IllegalArgumentException("value of " + this + " is not boolean");
    }

    private Object createConstantValue(Class<?> clazz, String value) {
        if (clazz.isPrimitive()) {
            clazz = ReflectionHelper.primitiveToWrapperClass(clazz);
        }
        if (value == null) {
            throw new IllegalArgumentException("value must be non-null");
        }
        if (value.length() == 0) {
            throw new IllegalArgumentException("value must not be the empty string");
        }
        try {
            if (clazz.isEnum()) {
                return Enum.valueOf(clazz, value);
            }
            if (DMoney.class.isAssignableFrom(clazz)) {
                return new DMoney(value, FormatHelper.determineScale(value));
            }
            if (BMoney.class.isAssignableFrom(clazz)) {
                return new BMoney(value, FormatHelper.determineScale(value));
            }
            if (BigDecimal.class.isAssignableFrom(clazz)) {
                return new BigDecimal(value);
            }
            if (BigInteger.class.isAssignableFrom(clazz)) {
                return new BigInteger(value);
            }
            if (Double.class == clazz) {
                return Double.valueOf(value);
            }
            if (Float.class == clazz) {
                return Float.valueOf(value);
            }
            if (Long.class == clazz) {
                return Long.valueOf(value);
            }
            if (Integer.class == clazz) {
                return Integer.valueOf(value);
            }
            if (Short.class == clazz) {
                return Short.valueOf(value);
            }
            if (Byte.class == clazz) {
                return Byte.valueOf(value);
            }
            if (Character.class == clazz) {
                return Character.valueOf(value.charAt(0));
            }
            if (String.class == clazz) {
                return value;
            }
            if (Boolean.class == clazz) {
                return Boolean.valueOf(value);
            }
            if (Timestamp.class.isAssignableFrom(clazz)) {
                return FormatHelper.parseTimestamp(value);
            }
            if (Time.class.isAssignableFrom(clazz)) {
                return FormatHelper.parseTime(value);
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return FormatHelper.parseDate(value);
            }
        }
        catch (NumberFormatException | ParseException ex) {
            throw new IllegalArgumentException("cannot create " + clazz.getName() + " from '" + value + "'", ex);
        }
        throw new IllegalArgumentException("unsupported type: " + clazz.getName());
    }

    private Object convertValue(Class<?> clazz, Object value) {
        try {
            if (clazz.isEnum() && value instanceof String) {
                return Enum.valueOf(clazz, (String)value);
            }
            if (DMoney.class.isAssignableFrom(clazz)) {
                if (value instanceof DMoney) {
                    return value;
                }
                if (value instanceof BigDecimal) {
                    return new DMoney((BigDecimal)value);
                }
                if (value instanceof String) {
                    return new DMoney((String)value, FormatHelper.determineScale((String)value));
                }
            }
            if (BMoney.class.isAssignableFrom(clazz)) {
                if (value instanceof BMoney) {
                    return value;
                }
                if (value instanceof BigDecimal) {
                    return new BMoney((BigDecimal)value);
                }
                if (value instanceof String) {
                    return new BMoney((String)value, FormatHelper.determineScale((String)value));
                }
            } else if (BigDecimal.class.isAssignableFrom(clazz)) {
                if (value instanceof BigDecimal) {
                    return value;
                }
                if (value instanceof String) {
                    return new BMoney((String)value, FormatHelper.determineScale((String)value));
                }
            } else if (BigInteger.class.isAssignableFrom(clazz)) {
                if (value instanceof BigInteger) {
                    return value;
                }
                if (value instanceof Number) {
                    return BigInteger.valueOf(((Number)value).longValue());
                }
                if (value instanceof String) {
                    return new BigInteger((String)value);
                }
            } else if (Double.class == clazz) {
                if (value instanceof Double) {
                    return value;
                }
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                if (value instanceof String) {
                    return Double.parseDouble((String)value);
                }
            } else if (Float.class == clazz) {
                if (value instanceof Float) {
                    return value;
                }
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                if (value instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)value));
                }
            } else if (Long.class == clazz) {
                if (value instanceof Long) {
                    return value;
                }
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof String) {
                    return Long.parseLong((String)value);
                }
            } else if (Integer.class == clazz) {
                if (value instanceof Integer) {
                    return value;
                }
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                if (value instanceof String) {
                    return Integer.parseInt((String)value);
                }
            } else if (Short.class == clazz) {
                if (value instanceof Short) {
                    return value;
                }
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                if (value instanceof String) {
                    return Short.parseShort((String)value);
                }
            } else if (Byte.class == clazz) {
                if (value instanceof Byte) {
                    return value;
                }
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                if (value instanceof String) {
                    return Byte.parseByte((String)value);
                }
            } else if (Character.class == clazz) {
                if (value instanceof Character) {
                    return value;
                }
            } else {
                if (String.class == clazz) {
                    if (value instanceof Character) {
                        return value;
                    }
                    return value.toString();
                }
                if (Boolean.class == clazz) {
                    if (value instanceof Boolean) {
                        return value;
                    }
                    if (value instanceof String) {
                        return Boolean.valueOf((String)value);
                    }
                } else if (Timestamp.class.isAssignableFrom(clazz)) {
                    if (value instanceof Timestamp) {
                        return value;
                    }
                    if (value instanceof String) {
                        return FormatHelper.parseTimestamp((String)value);
                    }
                } else if (Time.class.isAssignableFrom(clazz)) {
                    if (value instanceof Time) {
                        return value;
                    }
                    if (value instanceof String) {
                        return FormatHelper.parseTime((String)value);
                    }
                } else if (Date.class.isAssignableFrom(clazz)) {
                    if (value instanceof Date) {
                        return value;
                    }
                    if (value instanceof String) {
                        return FormatHelper.parseDate((String)value);
                    }
                }
            }
        }
        catch (NumberFormatException | ParseException ex) {
            throw new IllegalArgumentException("conversion failed", ex);
        }
        throw new IllegalArgumentException("unsupported conversion: " + value.getClass().getName() + " -> " + clazz.getName());
    }

    public static enum Type {
        CONSTANT,
        REFERENCE,
        STATIC_REFERENCE,
        SCRIPT;

    }
}

