/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.tentackle.common.TentackleRuntimeException;

public class ConcurrencyHelper {
    public static Executor createBlockingExecutor(Executor executor) {
        return new BlockingExecutor(executor);
    }

    private ConcurrencyHelper() {
    }

    private static class BlockingExecutor
    implements Executor {
        private final Executor executor;

        private BlockingExecutor(Executor executor) {
            this.executor = executor;
        }

        @Override
        public void execute(Runnable command) {
            FutureTask<Object> task = new FutureTask<Object>(command, null);
            this.executor.execute(task);
            while (true) {
                try {
                    task.get();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (ExecutionException ex) {
                    throw new TentackleRuntimeException("blocking execution failed", (Throwable)ex);
                }
                break;
            }
        }
    }
}

