/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.misc.Convertible;

public final class ConvertibleHelper {
    private static final ConcurrentHashMap<Class<? extends Convertible<?>>, Method> METHOD_MAP = new ConcurrentHashMap();

    public static <C extends Convertible<T>, T> C toInternal(Class<C> clazz, T external) {
        Method method = METHOD_MAP.get(clazz);
        if (method == null) {
            try {
                method = clazz.getDeclaredMethod("toInternal", external.getClass());
                if (Modifier.isStatic(method.getModifiers())) {
                    METHOD_MAP.put(clazz, method);
                }
            }
            catch (NoSuchMethodException nsm) {
                throw new RuntimeException("class " + clazz.getName() + " does not provide static method 'toInternal'");
            }
        }
        try {
            return (C)((Convertible)method.invoke(null, external));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new TentackleRuntimeException("invocation of " + method + " failed", (Throwable)e);
        }
    }

    private ConvertibleHelper() {
    }
}

