/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import org.tentackle.common.TentackleRuntimeException;

public class CopyOnWriteCollection<E>
implements Collection<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Collection<E> collection;
    private transient boolean notCloned = true;
    private final transient Method cloneMethod;
    private final boolean iteratorModifying;

    public CopyOnWriteCollection(Collection<E> collection, boolean iteratorModifying) {
        if (!(collection instanceof Cloneable)) {
            throw new IllegalArgumentException(collection.getClass() + " does not implement Cloneable");
        }
        try {
            this.cloneMethod = collection.getClass().getMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(collection.getClass() + " does not provide a clone-method");
        }
        this.collection = collection;
        this.iteratorModifying = iteratorModifying;
    }

    public CopyOnWriteCollection(Collection<E> collection) {
        this(collection, false);
    }

    protected Collection<E> clonedCollection() {
        if (this.notCloned) {
            try {
                this.collection = (Collection)this.cloneMethod.invoke(this.collection, new Object[0]);
                this.notCloned = false;
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new TentackleRuntimeException("cloning collection failed");
            }
        }
        return this.collection;
    }

    public boolean isCloned() {
        return !this.notCloned;
    }

    protected Collection<E> collection() {
        return this.collection;
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        if (this.iteratorModifying) {
            return this.clonedCollection().iterator();
        }
        return this.createReadOnlyIterator(this.collection.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.collection.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.clonedCollection().add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.clonedCollection().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.clonedCollection().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.clonedCollection().addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.clonedCollection().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.clonedCollection().retainAll(c);
    }

    @Override
    public void clear() {
        this.clonedCollection().clear();
    }

    protected Iterator<E> createReadOnlyIterator(Iterator<E> iterator) {
        return new ReadOnlyIterator<E>(iterator);
    }

    public static final class ReadOnlyIterator<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;

        public ReadOnlyIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            this.iterator.forEachRemaining(action);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator#remove() not supported with iteratorModifying=false");
        }
    }
}

