/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.tentackle.misc.CopyOnWriteCollection;

public class CopyOnWriteList<E>
extends CopyOnWriteCollection<E>
implements List<E> {
    private static final long serialVersionUID = 1L;
    private final boolean listIteratorModifying;

    public CopyOnWriteList(List<E> list, boolean iteratorModifying, boolean listIteratorModifying) {
        super(list, iteratorModifying);
        this.listIteratorModifying = listIteratorModifying;
    }

    public CopyOnWriteList(List<E> list) {
        this(list, false, true);
    }

    protected List<E> list() {
        return (List)this.collection();
    }

    protected List<E> clonedList() {
        return (List)this.clonedCollection();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.clonedList().addAll(index, c);
    }

    @Override
    public E get(int index) {
        return this.list().get(index);
    }

    @Override
    public E set(int index, E element) {
        return this.clonedList().set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.clonedList().add(index, element);
    }

    @Override
    public E remove(int index) {
        return this.clonedList().remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        if (this.listIteratorModifying) {
            return this.clonedList().listIterator();
        }
        return this.createReadOnlyListIterator(this.list().listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (this.listIteratorModifying) {
            return this.clonedList().listIterator(index);
        }
        return this.createReadOnlyListIterator(this.list().listIterator(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new CopyOnWriteList<E>(this.list().subList(fromIndex, toIndex));
    }

    protected ListIterator<E> createReadOnlyListIterator(ListIterator<E> iterator) {
        return new ReadOnlyListIterator<E>(iterator);
    }

    public static final class ReadOnlyListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> iterator;

        public ReadOnlyListIterator(ListIterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public E previous() {
            return this.iterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ListIterator#remove() not supported with listIteratorModifying=false");
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException("ListIterator#set() not supported with listIteratorModifying=false");
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException("ListIterator#add() not supported with listIteratorModifying=false");
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }
    }
}

