/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.tentackle.common.Date;
import org.tentackle.common.Time;
import org.tentackle.common.Timestamp;

public final class DateHelper {
    public static final Date MIN_DATE = new Date(0L);
    public static final Timestamp MIN_TIMESTAMP = new Timestamp(0L);

    public static long toMillis(java.util.Date date) {
        return date == null ? 0L : date.getTime();
    }

    public static Date toDate(java.util.Date date) {
        return date == null ? null : new Date(date.getTime());
    }

    public static Date toDate(Calendar cal) {
        return cal == null ? null : new Date(cal.getTime().getTime());
    }

    public static Time toTime(java.util.Date date) {
        return date == null ? null : new Time(date.getTime());
    }

    public static Time toTime(Calendar cal) {
        return cal == null ? null : new Time(cal.getTime().getTime());
    }

    public static Timestamp toTimestamp(java.util.Date date) {
        return date == null ? null : new Timestamp(date.getTime());
    }

    public static Timestamp toTimestamp(Calendar cal) {
        return cal == null ? null : new Timestamp(cal.getTime().getTime());
    }

    public static Date today() {
        return new Date(System.currentTimeMillis());
    }

    public static Date today(int dayOffset, int monthOffset, int yearOffset) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(5, dayOffset);
        cal.add(2, monthOffset);
        cal.add(1, yearOffset);
        return new Date(cal.getTimeInMillis());
    }

    public static Time daytime() {
        return new Time(System.currentTimeMillis());
    }

    public static Time daytime(int secondOffset, int minuteOffset, int hourOffset) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(13, secondOffset);
        cal.add(12, minuteOffset);
        cal.add(10, hourOffset);
        return new Time(cal.getTimeInMillis());
    }

    public static Timestamp now(long offsetMillis) {
        return new Timestamp(System.currentTimeMillis() + offsetMillis);
    }

    public static Timestamp now() {
        return DateHelper.now(0L);
    }

    public static void setMidnight(GregorianCalendar greg) {
        greg.set(11, 0);
        greg.set(12, 0);
        greg.set(13, 0);
        greg.set(14, 0);
    }

    public static int convert2DigitYearTo4DigitYear(int year2, int currentYear4) {
        int year = year2 % 100;
        int current2Year = currentYear4 % 100;
        int currentCentury = currentYear4 - current2Year;
        int pastCentury = currentCentury - 100;
        int nextCentury = currentCentury + 100;
        int currentDistance = Math.abs(currentCentury + year - currentYear4);
        int pastDistance = Math.abs(pastCentury + year - currentYear4);
        int nextDistance = Math.abs(nextCentury + year - currentYear4);
        year = currentDistance <= pastDistance ? (currentDistance <= nextDistance ? (year += currentCentury) : (year += nextCentury)) : (pastDistance <= nextDistance ? (year += pastCentury) : (year += nextCentury));
        return year;
    }

    public static int convert2DigitYearTo4DigitYear(int year2) {
        return DateHelper.convert2DigitYearTo4DigitYear(year2, new GregorianCalendar().get(1));
    }

    private DateHelper() {
    }
}

