/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.tentackle.common.ExceptionHelper;
import org.tentackle.common.Service;
import org.tentackle.misc.DiagnosticUtilitiesHolder;
import org.tentackle.task.TaskDispatcher;

@Service(value=DiagnosticUtilities.class)
public class DiagnosticUtilities {
    private final AtomicLong dumpCount = new AtomicLong();

    public static DiagnosticUtilities getInstance() {
        return DiagnosticUtilitiesHolder.INSTANCE;
    }

    protected void doCreateStackDump(StringBuilder buf, ThreadInfo info, Thread thread) {
        buf.append(info.toString());
        if (thread instanceof TaskDispatcher) {
            buf.append("    is a TaskDispatcher:\n    ");
            buf.append(((TaskDispatcher)((Object)thread)).toDiagnosticString());
            buf.append("\n\n");
        }
    }

    protected void doCreateStackDump(StringBuilder buf) {
        ThreadInfo[] infos;
        HashMap<Long, Thread> threadIdMap = new HashMap<Long, Thread>();
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            threadIdMap.put(thread.getId(), thread);
        }
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo info : infos = bean.dumpAllThreads(true, true)) {
            this.doCreateStackDump(buf, info, (Thread)threadIdMap.get(info.getThreadId()));
        }
        long[] threadIds = bean.findDeadlockedThreads();
        if (threadIds != null && threadIds.length > 0) {
            buf.append("\n!!!!!!!!!!!!!!!!!!!!!!!! DEADLOCKS FOUND !!!!!!!!!!!!!!!!!!!!!!!!!!\n\n");
            for (ThreadInfo info : infos = bean.getThreadInfo(threadIds, true, true)) {
                this.doCreateStackDump(buf, info, (Thread)threadIdMap.get(info.getThreadId()));
            }
        }
    }

    public String createStackDump() {
        StringBuilder buf = new StringBuilder("\n-------------------- Stackdump ");
        buf.append(this.dumpCount.incrementAndGet()).append(" --------------------\n\n");
        try {
            this.doCreateStackDump(buf);
        }
        catch (RuntimeException ex) {
            buf.append("CREATING STACKDUMP FAILED:\n").append(ExceptionHelper.getStackTraceAsString((Throwable)ex));
        }
        buf.append("\n-------------------- End Of Stackdump ").append(this.dumpCount).append(" --------------------\n\n");
        return buf.toString();
    }
}

