/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.text.DecimalFormat;
import org.tentackle.common.TentackleRuntimeException;

public class Duration {
    private static final DecimalFormat DURATION_FORMAT = new DecimalFormat("#0.000");
    private static final String INVALID_DURATION_TEXT = "?";
    private final long start = System.nanoTime();
    private long end;
    private boolean durationValid;

    public Duration() {
    }

    public Duration(long nanos) {
        this();
        this.end = this.start + nanos;
        this.durationValid = true;
    }

    public Duration zero() {
        this.end = this.start;
        this.durationValid = true;
        return this;
    }

    public Duration end() {
        this.end = System.nanoTime();
        this.durationValid = true;
        return this;
    }

    public boolean isValid() {
        return this.durationValid;
    }

    public void invalidate() {
        this.durationValid = false;
    }

    public long nanos() {
        this.assertDurationValid();
        return this.end - this.start;
    }

    public double micros() {
        return (double)this.nanos() / 1000.0;
    }

    public double millis() {
        return (double)this.nanos() / 1000000.0;
    }

    public double seconds() {
        return (double)this.nanos() / 1.0E9;
    }

    public Duration add(Duration duration) {
        this.assertDurationValid();
        this.end += duration.nanos();
        return this;
    }

    public Duration subtract(Duration duration) {
        this.assertDurationValid();
        this.end -= duration.nanos();
        return this;
    }

    public String toString() {
        return this.isValid() ? Long.toString(this.nanos()) : INVALID_DURATION_TEXT;
    }

    public String microsToString() {
        return this.durationToString(this.micros());
    }

    public String millisToString() {
        return this.durationToString(this.millis());
    }

    public String secondsToString() {
        return this.durationToString(this.seconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String durationToString(double duration) {
        if (this.isValid()) {
            DecimalFormat decimalFormat = DURATION_FORMAT;
            synchronized (decimalFormat) {
                return DURATION_FORMAT.format(duration);
            }
        }
        return INVALID_DURATION_TEXT;
    }

    protected void assertDurationValid() {
        if (!this.durationValid) {
            throw new TentackleRuntimeException("duration not valid");
        }
    }
}

