/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.tentackle.common.BMoney;
import org.tentackle.common.Date;
import org.tentackle.common.LocaleProvider;
import org.tentackle.common.Time;
import org.tentackle.common.Timestamp;
import org.tentackle.misc.MiscCoreBundle;

public class FormatHelper {
    private static final Map<Locale, Formatting> FORMATTING_MAP = new HashMap<Locale, Formatting>();

    private static Formatting getFormatting() {
        Locale locale = LocaleProvider.getInstance().getLocale();
        return FORMATTING_MAP.computeIfAbsent(locale, l -> new Formatting((Locale)l, new Patterns(locale)));
    }

    public static synchronized void applyPatterns(Locale locale, Patterns patterns) {
        FORMATTING_MAP.put(locale, new Formatting(locale, patterns));
    }

    public static void applyPatterns(Patterns patterns) {
        Locale locale = LocaleProvider.getInstance().getLocale();
        FormatHelper.applyPatterns(locale, patterns);
    }

    public static synchronized String getIntegerPattern() {
        return FormatHelper.getFormatting().integerPattern;
    }

    public static synchronized String getFloatingNumberPattern() {
        return FormatHelper.getFormatting().floatingNumberPattern;
    }

    public static synchronized String getMoneyPattern() {
        return FormatHelper.getFormatting().moneyPattern;
    }

    public static synchronized String getTimestampPattern() {
        return FormatHelper.getFormatting().timestampPattern;
    }

    public static synchronized String getShortTimestampPattern() {
        return FormatHelper.getFormatting().shortTimestampPattern;
    }

    public static synchronized String getDatePattern() {
        return FormatHelper.getFormatting().datePattern;
    }

    public static synchronized String getShortDatePattern() {
        return FormatHelper.getFormatting().shortDatePattern;
    }

    public static synchronized String getTimePattern() {
        return FormatHelper.getFormatting().timePattern;
    }

    public static synchronized String getShortTimePattern() {
        return FormatHelper.getFormatting().shortTimePattern;
    }

    public static synchronized Number parseInteger(String str) throws ParseException {
        return FormatHelper.getFormatting().integerFormat.parse(str);
    }

    public static synchronized Number parseFloatingNumber(String str) throws ParseException {
        return FormatHelper.getFormatting().floatingNumberFormat.parse(str);
    }

    public static synchronized Number parseMoney(String str) throws ParseException {
        return FormatHelper.getFormatting().moneyFormat.parse(str);
    }

    public static synchronized Timestamp parseTimestamp(String str) throws ParseException {
        return new Timestamp(FormatHelper.getFormatting().timestampFormat.parse(str).getTime());
    }

    public static synchronized Timestamp parseShortTimestamp(String str) throws ParseException {
        return new Timestamp(FormatHelper.getFormatting().shortTimestampFormat.parse(str).getTime());
    }

    public static synchronized Date parseDate(String str) throws ParseException {
        return new Date(FormatHelper.getFormatting().dateFormat.parse(str).getTime());
    }

    public static synchronized Date parseShortDate(String str) throws ParseException {
        return new Date(FormatHelper.getFormatting().shortDateFormat.parse(str).getTime());
    }

    public static synchronized Time parseTime(String str) throws ParseException {
        return new Time(FormatHelper.getFormatting().timeFormat.parse(str).getTime());
    }

    public static synchronized Time parseShortTime(String str) throws ParseException {
        return new Time(FormatHelper.getFormatting().shortTimeFormat.parse(str).getTime());
    }

    public static LocalDateTime parseLocalDateTime(String str) {
        return LocalDateTime.parse(str, FormatHelper.getFormatting().localDateTimeFormat);
    }

    public static LocalDateTime parseShortLocalDateTime(String str) {
        return LocalDateTime.parse(str, FormatHelper.getFormatting().shortLocalDateTimeFormat);
    }

    public static LocalDate parseLocalDate(String str) {
        return LocalDate.parse(str, FormatHelper.getFormatting().localDateFormat);
    }

    public static LocalDate parseShortLocalDate(String str) {
        return LocalDate.parse(str, FormatHelper.getFormatting().shortLocalDateFormat);
    }

    public static LocalTime parseLocalTime(String str) {
        return LocalTime.parse(str, FormatHelper.getFormatting().localTimeFormat);
    }

    public static LocalTime parseShortLocalTime(String str) {
        return LocalTime.parse(str, FormatHelper.getFormatting().shortLocalTimeFormat);
    }

    public static synchronized String formatInteger(Number number) {
        return FormatHelper.getFormatting().integerFormat.format(number);
    }

    public static synchronized String formatFloatingNumber(Number number) {
        return FormatHelper.getFormatting().floatingNumberFormat.format(number);
    }

    public static synchronized String formatMoney(Number number) {
        return FormatHelper.getFormatting().moneyFormat.format(number);
    }

    public static synchronized String formatTimestamp(java.util.Date timestamp) {
        return FormatHelper.getFormatting().timestampFormat.format(timestamp);
    }

    public static synchronized String formatShortTimestamp(java.util.Date timestamp) {
        return FormatHelper.getFormatting().shortTimestampFormat.format(timestamp);
    }

    public static synchronized String formatDate(java.util.Date date) {
        return FormatHelper.getFormatting().dateFormat.format(date);
    }

    public static synchronized String formatShortDate(java.util.Date date) {
        return FormatHelper.getFormatting().shortDateFormat.format(date);
    }

    public static synchronized String formatTime(java.util.Date time) {
        return FormatHelper.getFormatting().timeFormat.format(time);
    }

    public static synchronized String formatShortTime(java.util.Date time) {
        return FormatHelper.getFormatting().shortTimeFormat.format(time);
    }

    public static String formatLocalDateTime(LocalDateTime timestamp) {
        return FormatHelper.getFormatting().localDateTimeFormat.format(timestamp);
    }

    public static String formatShortLocalDateTime(LocalDateTime timestamp) {
        return FormatHelper.getFormatting().shortLocalDateTimeFormat.format(timestamp);
    }

    public static String formatLocalDate(LocalDate date) {
        return FormatHelper.getFormatting().localDateFormat.format(date);
    }

    public static String formatShortLocalDate(LocalDate date) {
        return FormatHelper.getFormatting().shortLocalDateFormat.format(date);
    }

    public static String formatLocalTime(LocalTime time) {
        return FormatHelper.getFormatting().localTimeFormat.format(time);
    }

    public static String formatShortLocalTime(LocalTime time) {
        return FormatHelper.getFormatting().shortLocalTimeFormat.format(time);
    }

    public static DateTimeFormatter getLocalDateTimeFormatter() {
        return FormatHelper.getFormatting().localDateTimeFormat;
    }

    public static DateTimeFormatter getLocalDateFormatter() {
        return FormatHelper.getFormatting().localDateFormat;
    }

    public static DateTimeFormatter getLocalTimeFormatter() {
        return FormatHelper.getFormatting().localTimeFormat;
    }

    public static DateTimeFormatter getShortLocalDateTimeFormatter() {
        return FormatHelper.getFormatting().shortLocalDateTimeFormat;
    }

    public static DateTimeFormatter getShortLocalDateFormatter() {
        return FormatHelper.getFormatting().shortLocalDateFormat;
    }

    public static DateTimeFormatter getShortLocalTimeFormatter() {
        return FormatHelper.getFormatting().shortLocalTimeFormat;
    }

    public static synchronized int determineScale(String value) {
        int scale = 0;
        if (value != null) {
            int len = value.length();
            char sep = FormatHelper.getFormatting().floatingNumberFormat.getDecimalFormatSymbols().getDecimalSeparator();
            int ndx = value.lastIndexOf(sep);
            if (ndx >= 0) {
                scale = len - ndx - 1;
            }
        }
        return scale;
    }

    public static void setScale(DecimalFormat format, int scale) {
        String fmt = format.toPattern();
        boolean groupingUsed = format.isGroupingUsed();
        int groupingSize = format.getGroupingSize();
        int dotNdx = fmt.lastIndexOf(46);
        if (dotNdx < 0) {
            dotNdx = fmt.length();
        }
        fmt = dotNdx > 0 ? fmt.substring(0, dotNdx) : "#0";
        if (scale > 0) {
            StringBuilder buf = new StringBuilder(fmt).append('.');
            for (int i = 0; i < scale; ++i) {
                buf.append('0');
            }
            fmt = buf.toString();
        }
        format.applyPattern(fmt);
        if (dotNdx <= 0 && groupingUsed) {
            format.setGroupingSize(groupingSize);
            format.setGroupingUsed(true);
        }
    }

    public static synchronized String debitCreditToString(BMoney money, boolean debit) {
        return FormatHelper.getFormatting().debitCreditToString(money, debit);
    }

    public static boolean isFormattingTime(SimpleDateFormat format) {
        String fmt = format.toPattern();
        return fmt.indexOf(72) >= 0 || fmt.indexOf(107) >= 0 || fmt.indexOf(75) >= 0 || fmt.indexOf(104) >= 0 || fmt.indexOf(109) >= 0 || fmt.indexOf(115) >= 0 || fmt.indexOf(83) >= 0;
    }

    public static boolean isFormattingDate(SimpleDateFormat format) {
        String fmt = format.toPattern();
        return fmt.indexOf(121) >= 0 || fmt.indexOf(77) >= 0 || fmt.indexOf(119) >= 0 || fmt.indexOf(87) >= 0 || fmt.indexOf(68) >= 0 || fmt.indexOf(100) >= 0 || fmt.indexOf(70) >= 0 || fmt.indexOf(69) >= 0;
    }

    public static String calendarFieldToString(int field, boolean plural) {
        switch (field) {
            case 1: {
                return plural ? MiscCoreBundle.getString("years") : MiscCoreBundle.getString("year");
            }
            case 2: {
                return plural ? MiscCoreBundle.getString("months") : MiscCoreBundle.getString("month");
            }
            case 3: {
                return plural ? MiscCoreBundle.getString("weeks") : MiscCoreBundle.getString("week");
            }
            case 5: {
                return plural ? MiscCoreBundle.getString("days") : MiscCoreBundle.getString("day");
            }
            case 10: 
            case 11: {
                return plural ? MiscCoreBundle.getString("hours") : MiscCoreBundle.getString("hour");
            }
            case 12: {
                return plural ? MiscCoreBundle.getString("minutes") : MiscCoreBundle.getString("minute");
            }
            case 13: {
                return plural ? MiscCoreBundle.getString("seconds") : MiscCoreBundle.getString("second");
            }
            case 14: {
                return plural ? MiscCoreBundle.getString("milliseconds") : MiscCoreBundle.getString("millisecond");
            }
        }
        return "";
    }

    private FormatHelper() {
    }

    private static class Formatting {
        private final String integerPattern;
        private final String floatingNumberPattern;
        private final String moneyPattern;
        private final String timestampPattern;
        private final String datePattern;
        private final String timePattern;
        private final String shortTimestampPattern;
        private final String shortDatePattern;
        private final String shortTimePattern;
        private final DecimalFormat integerFormat;
        private final DecimalFormat floatingNumberFormat;
        private final DecimalFormat moneyFormat;
        private final SimpleDateFormat timestampFormat;
        private final SimpleDateFormat dateFormat;
        private final SimpleDateFormat timeFormat;
        private final SimpleDateFormat shortTimestampFormat;
        private final SimpleDateFormat shortDateFormat;
        private final SimpleDateFormat shortTimeFormat;
        private final DateTimeFormatter localDateTimeFormat;
        private final DateTimeFormatter localDateFormat;
        private final DateTimeFormatter localTimeFormat;
        private final DateTimeFormatter shortLocalDateTimeFormat;
        private final DateTimeFormatter shortLocalDateFormat;
        private final DateTimeFormatter shortLocalTimeFormat;
        private final char debitLetter;
        private final String debitString;
        private final char creditLetter;
        private final String creditString;

        private Formatting(Locale locale, Patterns patterns) {
            this.integerPattern = patterns.integerPattern;
            this.floatingNumberPattern = patterns.floatingNumberPattern;
            this.moneyPattern = patterns.moneyPattern;
            this.timestampPattern = patterns.timestampPattern;
            this.datePattern = patterns.datePattern;
            this.timePattern = patterns.timePattern;
            this.shortTimestampPattern = patterns.shortTimestampPattern;
            this.shortDatePattern = patterns.shortDatePattern;
            this.shortTimePattern = patterns.shortTimePattern;
            this.debitLetter = patterns.debitLetter;
            this.creditLetter = patterns.creditLetter;
            this.debitString = " " + this.debitLetter + "    ";
            this.creditString = " " + this.creditLetter;
            this.integerFormat = new DecimalFormat(this.integerPattern);
            this.floatingNumberFormat = new DecimalFormat(this.floatingNumberPattern);
            this.moneyFormat = new DecimalFormat(this.moneyPattern);
            this.timestampFormat = new SimpleDateFormat(this.timestampPattern, locale);
            this.dateFormat = new SimpleDateFormat(this.datePattern, locale);
            this.timeFormat = new SimpleDateFormat(this.timePattern, locale);
            this.shortTimestampFormat = new SimpleDateFormat(this.shortTimestampPattern, locale);
            this.shortDateFormat = new SimpleDateFormat(this.shortDatePattern, locale);
            this.shortTimeFormat = new SimpleDateFormat(this.shortTimePattern, locale);
            this.localDateTimeFormat = DateTimeFormatter.ofPattern(this.timestampPattern, locale);
            this.localDateFormat = DateTimeFormatter.ofPattern(this.datePattern, locale);
            this.localTimeFormat = DateTimeFormatter.ofPattern(this.timePattern, locale);
            this.shortLocalDateTimeFormat = DateTimeFormatter.ofPattern(this.shortTimestampPattern, locale);
            this.shortLocalDateFormat = DateTimeFormatter.ofPattern(this.shortDatePattern, locale);
            this.shortLocalTimeFormat = DateTimeFormatter.ofPattern(this.shortTimePattern, locale);
        }

        private String debitCreditToString(BMoney money, boolean debit) {
            if (money == null) {
                return "";
            }
            FormatHelper.setScale(this.moneyFormat, money.scale());
            return debit ? this.moneyFormat.format(money) + this.debitString : "    " + this.moneyFormat.format(money) + this.creditString;
        }
    }

    public static class Patterns {
        public String integerPattern;
        public String floatingNumberPattern;
        public String moneyPattern;
        public String timestampPattern;
        public String datePattern;
        public String timePattern;
        public String shortTimestampPattern;
        public String shortDatePattern;
        public String shortTimePattern;
        public char debitLetter;
        public char creditLetter;

        public Patterns() {
        }

        public Patterns(Locale locale) {
            this.integerPattern = MiscCoreBundle.getString(locale, "integerPattern");
            this.floatingNumberPattern = MiscCoreBundle.getString(locale, "floatingNumberPattern");
            this.moneyPattern = MiscCoreBundle.getString(locale, "moneyPattern");
            this.integerPattern = MiscCoreBundle.getString(locale, "integerPattern");
            this.timestampPattern = MiscCoreBundle.getString(locale, "timestampPattern");
            this.datePattern = MiscCoreBundle.getString(locale, "datePattern");
            this.timePattern = MiscCoreBundle.getString(locale, "timePattern");
            this.shortTimestampPattern = MiscCoreBundle.getString(locale, "shortTimestampPattern");
            this.shortDatePattern = MiscCoreBundle.getString(locale, "shortDatePattern");
            this.shortTimePattern = MiscCoreBundle.getString(locale, "shortTimePattern");
            this.debitLetter = MiscCoreBundle.getString(locale, "debitLetter").charAt(0);
            this.creditLetter = MiscCoreBundle.getString(locale, "creditLetter").charAt(0);
        }
    }
}

