/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.misc.Identifiable;
import org.tentackle.misc.SerialNumbered;

public class IdSerialTuple
implements Identifiable,
SerialNumbered,
Cloneable,
Comparable<IdSerialTuple> {
    private static final long serialVersionUID = 4038857102103180382L;
    private long id;
    private long serial;

    public IdSerialTuple(long id, long serial) {
        this.id = id;
        this.serial = serial;
    }

    @Override
    public int compareTo(IdSerialTuple o) {
        return Long.compare(this.id, o.id);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdSerialTuple other = (IdSerialTuple)obj;
        return this.id == other.id;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (int)(this.id ^ this.id >>> 32);
        return hash;
    }

    public IdSerialTuple clone() {
        try {
            return (IdSerialTuple)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new TentackleRuntimeException("clone failed", (Throwable)ex);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public String toString() {
        return "[" + this.id + "/" + this.serial + "]";
    }

    @Override
    public String toGenericString() {
        return this.toString();
    }

    @Override
    public long getSerial() {
        return this.serial;
    }

    @Override
    public void setSerial(long serial) {
        this.serial = serial;
    }

    @Override
    public boolean isVirgin() {
        return this.serial == 0L;
    }
}

