/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.io.Serializable;
import org.tentackle.misc.Identifiable;

public class IdentifiableKey<T extends Identifiable>
implements Comparable<IdentifiableKey<T>>,
Serializable {
    private static final long serialVersionUID = -2881185378941379031L;
    private final Class<T> identifiableClass;
    private final long identifiableId;

    public IdentifiableKey(Class<T> identifiableClass, long identifiableId) {
        this.identifiableClass = identifiableClass;
        this.identifiableId = identifiableId;
    }

    public IdentifiableKey(T identifiable) {
        this(identifiable.getClass(), identifiable.getId());
    }

    public IdentifiableKey(String identifiableClassName, long identifiableId) throws ClassNotFoundException {
        this(Class.forName(identifiableClassName), identifiableId);
    }

    public Class<T> getIdentifiableClass() {
        return this.identifiableClass;
    }

    public long getIdentifiableId() {
        return this.identifiableId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentifiableKey other = (IdentifiableKey)obj;
        if (!(this.identifiableClass == other.identifiableClass || this.identifiableClass != null && this.identifiableClass.equals(other.identifiableClass))) {
            return false;
        }
        return this.identifiableId == other.identifiableId;
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.identifiableClass != null ? this.identifiableClass.hashCode() : 0);
        hash = 43 * hash + (int)(this.identifiableId ^ this.identifiableId >>> 32);
        return hash;
    }

    @Override
    public int compareTo(IdentifiableKey<T> o) {
        int rv = this.identifiableClass.getName().compareTo(o.identifiableClass.getName());
        if (rv == 0) {
            rv = Long.compare(this.identifiableId, o.identifiableId);
        }
        return rv;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.identifiableClass != null) {
            buf.append(this.identifiableClass.getName());
        }
        buf.append('[');
        buf.append(this.identifiableId);
        buf.append(']');
        return buf.toString();
    }
}

