/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.tentackle.misc.Identifiable;
import org.tentackle.misc.IdentifiableKey;

public class IdentifiableMap<T extends Identifiable>
implements Serializable {
    private static final long serialVersionUID = -6365221025824797487L;
    private final Map<IdentifiableKey<T>, T> objectMap = new LinkedHashMap<IdentifiableKey<T>, T>();
    private Map<IdentifiableKey<T>, T> sortedObjectMap;

    public IdentifiableMap() {
    }

    public void clear() {
        this.objectMap.clear();
        this.sortedObjectMap = null;
    }

    public IdentifiableMap(T object) {
        this();
        this.add(object);
    }

    public T add(T object) {
        IdentifiableKey<T> key = new IdentifiableKey<T>(object);
        if (this.sortedObjectMap != null) {
            this.sortedObjectMap.put(key, object);
        }
        return (T)((Identifiable)this.objectMap.put(key, object));
    }

    public int add(Collection<? extends T> objects) {
        int count = 0;
        for (Identifiable object : objects) {
            if (this.add(object) != null) continue;
            ++count;
        }
        return count;
    }

    public <P extends T> P remove(Class<P> clazz, long id) {
        IdentifiableKey<P> key = new IdentifiableKey<P>(clazz, id);
        if (this.sortedObjectMap != null) {
            this.sortedObjectMap.remove(key);
        }
        return (P)((Identifiable)this.objectMap.remove(key));
    }

    public T remove(T object) {
        IdentifiableKey<T> key = new IdentifiableKey<T>(object);
        if (this.sortedObjectMap != null) {
            this.sortedObjectMap.remove(key);
        }
        return (T)((Identifiable)this.objectMap.remove(key));
    }

    public int remove(Collection<? extends T> objects) {
        int count = 0;
        for (Identifiable object : objects) {
            if (this.remove(object) == null) continue;
            ++count;
        }
        return count;
    }

    public <P extends T> P get(Class<P> clazz, long id) {
        return (P)((Identifiable)this.objectMap.get(new IdentifiableKey<P>(clazz, id)));
    }

    public Collection<T> getAll() {
        return this.objectMap.values();
    }

    public Collection<T> getAllSorted() {
        return this.getSortedMap().values();
    }

    public <P extends T> Collection<P> getAllSorted(Class<P> clazz) {
        return ((TreeMap)this.getSortedMap()).subMap(new IdentifiableKey<P>(clazz, Long.MIN_VALUE), new IdentifiableKey<P>(clazz, Long.MAX_VALUE)).values();
    }

    private Map<IdentifiableKey<T>, T> getSortedMap() {
        if (this.sortedObjectMap == null) {
            this.sortedObjectMap = new TreeMap<IdentifiableKey<T>, T>(this.objectMap);
        }
        return this.sortedObjectMap;
    }
}

