/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.tentackle.log.Logger;
import org.tentackle.misc.Immutable;
import org.tentackle.misc.ImmutableCollection;
import org.tentackle.misc.ImmutableException;

public class ImmutableArrayList<E>
extends ArrayList<E>
implements ImmutableCollection<E> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.get(ImmutableArrayList.class);
    private final int hash = new Object().hashCode();
    protected boolean simpleEqualsAndHashCode;
    protected boolean immutable;
    protected boolean finallyImmutable;
    protected Logger.Level immutableLoggingLevel;

    public ImmutableArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public ImmutableArrayList(Collection<? extends E> c) {
        super(c);
    }

    public ImmutableArrayList() {
    }

    @Override
    public void setSimpleEqualsAndHashCode(boolean simpleEqualsAndHashCode) {
        this.simpleEqualsAndHashCode = simpleEqualsAndHashCode;
    }

    @Override
    public boolean isSimpleEqualsAndHashCode() {
        return this.simpleEqualsAndHashCode;
    }

    @Override
    public int hashCode() {
        return this.simpleEqualsAndHashCode ? this.hash : super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.simpleEqualsAndHashCode ? this == o : super.equals(o);
    }

    @Override
    public void setImmutable(boolean immutable, boolean withElements) {
        if (!immutable && this.finallyImmutable) {
            throw new ImmutableException("list is finally immutable");
        }
        this.immutable = immutable;
        if (withElements) {
            for (Object obj : this) {
                if (!(obj instanceof Immutable)) continue;
                ((Immutable)obj).setImmutable(immutable);
            }
        }
    }

    @Override
    public void setFinallyImmutable(boolean withElements) {
        this.immutable = true;
        this.finallyImmutable = true;
        if (withElements) {
            for (Object obj : this) {
                if (!(obj instanceof Immutable)) continue;
                ((Immutable)obj).setFinallyImmutable();
            }
        }
    }

    @Override
    public void setImmutable(boolean immutable) {
        this.setImmutable(immutable, true);
    }

    @Override
    public void setFinallyImmutable() {
        this.setFinallyImmutable(true);
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    @Override
    public boolean isFinallyImmutable() {
        return this.finallyImmutable;
    }

    @Override
    public void setImmutableLoggingLevel(Logger.Level immutableLoggingLevel) {
        this.immutableLoggingLevel = immutableLoggingLevel;
    }

    @Override
    public Logger.Level getImmutableLoggingLevel() {
        return this.immutableLoggingLevel;
    }

    @Override
    public boolean add(E e) {
        this.assertMutable();
        return super.add(e);
    }

    @Override
    public void add(int index, E element) {
        this.assertMutable();
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.assertMutable();
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.assertMutable();
        return super.addAll(index, c);
    }

    @Override
    public E remove(int index) {
        this.assertMutable();
        return super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.assertMutable();
        return super.remove(o);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean someRemoved = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (collection.contains(obj)) continue;
            iter.remove();
            this.assertMutable();
            someRemoved = true;
        }
        return someRemoved;
    }

    @Override
    public E set(int index, E element) {
        E obj = super.set(index, element);
        if (obj != element) {
            try {
                this.assertMutable();
            }
            catch (ImmutableException imex) {
                super.set(index, obj);
                throw imex;
            }
        }
        return obj;
    }

    protected void assertMutable() {
        if (this.isImmutable()) {
            ImmutableException ex = new ImmutableException("list is immutable");
            if (this.immutableLoggingLevel == null) {
                throw ex;
            }
            LOGGER.log(this.immutableLoggingLevel, ((Throwable)((Object)ex)).getMessage(), (Throwable)((Object)ex));
        }
    }
}

