/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tentackle.misc.PropertyEvent;
import org.tentackle.misc.PropertyListener;

public class PropertySupport {
    private final Object source;
    private final Map<String, List<PropertyListener>> listenerMap;
    private List<PropertyListener> allPropsListeners;

    public PropertySupport(Object source) {
        this.source = source;
        this.listenerMap = new HashMap<String, List<PropertyListener>>();
    }

    public void addPropertyListener(PropertyListener l) {
        this.addListener("", l);
    }

    public void addPropertyListener(String propertyName, PropertyListener l) {
        if (propertyName == null) {
            propertyName = "";
        }
        this.addListener(propertyName, l);
    }

    public void removePropertyListener(PropertyListener l) {
        this.removeListener("", l);
    }

    public void removePropertyListener(String propertyName, PropertyListener l) {
        if (propertyName == null) {
            propertyName = "";
        }
        this.removeListener(propertyName, l);
    }

    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null || propertyName.isEmpty()) {
            throw new IllegalArgumentException("missing property name");
        }
        List<PropertyListener> listeners = this.listenerMap.get(propertyName);
        if (listeners != null && !listeners.isEmpty() || this.allPropsListeners != null && !this.allPropsListeners.isEmpty()) {
            PropertyEvent event = new PropertyEvent(this.source, propertyName, oldValue, newValue);
            if (listeners != null) {
                for (PropertyListener l : listeners) {
                    l.changed(event);
                }
            }
            if (this.allPropsListeners != null) {
                for (PropertyListener l : this.allPropsListeners) {
                    l.changed(event);
                }
            }
        }
    }

    private void addListener(String propertyName, PropertyListener l) {
        List<PropertyListener> listeners = this.listenerMap.get(propertyName);
        if (listeners == null) {
            listeners = new ArrayList<PropertyListener>();
            this.listenerMap.put(propertyName, listeners);
            if (propertyName.isEmpty()) {
                this.allPropsListeners = listeners;
            }
        }
        listeners.add(l);
    }

    private void removeListener(String propertyName, PropertyListener l) {
        List<PropertyListener> listeners = this.listenerMap.get(propertyName);
        if (listeners != null) {
            listeners.remove(l);
        }
    }
}

