/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.log.Logger;
import org.tentackle.misc.Identifiable;
import org.tentackle.misc.ImmutableArrayList;
import org.tentackle.misc.ImmutableException;
import org.tentackle.misc.Modifiable;
import org.tentackle.misc.Snapshotable;
import org.tentackle.misc.TrackedList;
import org.tentackle.misc.TrackedListListener;

public class TrackedArrayList<E>
extends ImmutableArrayList<E>
implements TrackedList<E> {
    private static final String MSG_NOT_MY_SNAPSHOT = "not my snapshot";
    private static final long serialVersionUID = 5820724718467532237L;
    private static final Logger LOGGER = Logger.get(TrackedArrayList.class);
    private boolean modified;
    private boolean removed;
    private boolean added;
    private Set<E> removedObjects;
    private boolean removedObjectsFiltered;
    private transient List<WeakReference<TrackedArrayList<E>>> snapshots;
    private transient List<E> elementSnapshots;
    private transient boolean copied;
    private transient List<TrackedListListener<E>> listeners;

    public TrackedArrayList(int initialCapacity, boolean modified) {
        super(initialCapacity);
        this.setModified(modified);
    }

    public TrackedArrayList(boolean modified) {
        this.setModified(modified);
    }

    public TrackedArrayList() {
        this(true);
    }

    public TrackedArrayList(Collection<E> collection) {
        super(collection);
    }

    @Override
    public TrackedArrayList<E> clone() {
        TrackedArrayList nlist = (TrackedArrayList)super.clone();
        nlist.init();
        nlist.copied = false;
        return nlist;
    }

    @Override
    public TrackedArrayList<E> createSnapshot() {
        if (this.snapshots == null) {
            this.snapshots = new ArrayList<WeakReference<TrackedArrayList<E>>>();
        }
        TrackedArrayList snapshot = (TrackedArrayList)super.clone();
        this.snapshots.add(new WeakReference<TrackedArrayList>(snapshot));
        snapshot.removedObjects = this.removedObjects == null ? null : new LinkedHashSet<E>(this.removedObjects);
        snapshot.snapshots = new ArrayList<WeakReference<TrackedArrayList<WeakReference<TrackedArrayList<E>>>>>(this.snapshots);
        snapshot.elementSnapshots = new ArrayList(this.size());
        boolean fineLoggable = LOGGER.isFineLoggable();
        for (Object obj : snapshot) {
            if (obj instanceof Snapshotable) {
                Object elementsnapshot = ((Snapshotable)obj).createSnapshot();
                if (fineLoggable) {
                    LOGGER.fine("creating snapshot for " + (obj instanceof Identifiable ? ((Identifiable)obj).toGenericString() : obj.toString()));
                }
                snapshot.elementSnapshots.add(elementsnapshot);
                continue;
            }
            if (fineLoggable) {
                LOGGER.fine("caution: not a Snapshotable! using reference for " + (obj instanceof Identifiable ? ((Identifiable)obj).toGenericString() : obj.toString()));
            }
            snapshot.elementSnapshots.add(obj);
        }
        snapshot.copied = false;
        return snapshot;
    }

    @Override
    public void revertToSnapshot(TrackedList<E> snapshot) {
        if (snapshot != null) {
            if (!snapshot.isSnapshot()) {
                throw new TentackleRuntimeException("not a snapshot");
            }
            boolean fineLoggable = LOGGER.isFineLoggable();
            if (this.isCopy()) {
                super.clear();
                for (E obj : ((TrackedArrayList)snapshot).elementSnapshots) {
                    if (obj instanceof Snapshotable) {
                        if (fineLoggable) {
                            LOGGER.fine("reverting to copy for " + (obj instanceof Identifiable ? ((Identifiable)obj).toGenericString() : obj.toString()));
                        }
                        super.add(((Snapshotable)obj).copy());
                        continue;
                    }
                    if (fineLoggable) {
                        LOGGER.fine("caution: not a Snapshotable! reverting to reference for " + (obj instanceof Identifiable ? ((Identifiable)obj).toGenericString() : obj.toString()));
                    }
                    super.add(obj);
                }
                this.init();
            } else if (this.getSnapshotIndex(snapshot) >= 0) {
                TrackedArrayList mySnapshot = (TrackedArrayList)snapshot;
                super.clear();
                int i = 0;
                for (Object obj : snapshot) {
                    if (obj instanceof Snapshotable) {
                        if (fineLoggable) {
                            LOGGER.fine("reverting to snapshot for " + (obj instanceof Identifiable ? ((Identifiable)obj).toGenericString() : obj.toString()));
                        }
                        ((Snapshotable)obj).revertToSnapshot(mySnapshot.elementSnapshots.get(i));
                    } else if (fineLoggable) {
                        LOGGER.fine("caution: not a Snapshotable! reverting to reference for " + (obj instanceof Identifiable ? ((Identifiable)obj).toGenericString() : obj.toString()));
                    }
                    super.add(obj);
                    ++i;
                }
                this.removedObjects = mySnapshot.removedObjects;
                this.removedObjectsFiltered = mySnapshot.removedObjectsFiltered;
                this.modified = mySnapshot.modified;
                this.removed = mySnapshot.removed;
                this.added = mySnapshot.added;
                this.immutable = mySnapshot.immutable;
                this.snapshots = mySnapshot.snapshots;
                this.simpleEqualsAndHashCode = mySnapshot.simpleEqualsAndHashCode;
            } else {
                throw new TentackleRuntimeException(MSG_NOT_MY_SNAPSHOT);
            }
        }
    }

    @Override
    public void discardSnapshot(TrackedList<E> snapshot) {
        int index = this.getSnapshotIndex(snapshot);
        if (index < 0) {
            throw new TentackleRuntimeException(MSG_NOT_MY_SNAPSHOT);
        }
        this.snapshots.remove(index);
    }

    @Override
    public void discardSnapshots() {
        this.snapshots = null;
    }

    @Override
    public boolean isCopy() {
        return this.copied;
    }

    @Override
    public void setCopy(boolean copy) {
        this.copied = copy;
        if (copy) {
            this.init();
        }
    }

    @Override
    public TrackedList<E> copy() {
        TrackedArrayList<Object> list = new TrackedArrayList<Object>(this.size(), false);
        boolean fineLoggable = LOGGER.isFineLoggable();
        for (Object obj : this) {
            if (obj instanceof Snapshotable) {
                if (fineLoggable) {
                    LOGGER.fine("creating deep copy for " + (obj instanceof Identifiable ? ((Identifiable)obj).toGenericString() : obj.toString()));
                }
                list.add(((Snapshotable)obj).copy());
                continue;
            }
            if (fineLoggable) {
                LOGGER.fine("caution: not a Snapshotable! copying reference for " + (obj instanceof Identifiable ? ((Identifiable)obj).toGenericString() : obj.toString()));
            }
            list.add(obj);
        }
        list.setCopy(true);
        list.setModified(true);
        return list;
    }

    @Override
    public boolean isSnapshot() {
        return this.elementSnapshots != null;
    }

    @Override
    public List<TrackedArrayList<E>> getSnapshots() {
        ArrayList<TrackedArrayList<TrackedArrayList>> shots = new ArrayList<TrackedArrayList<TrackedArrayList>>();
        if (this.snapshots != null) {
            Iterator<WeakReference<TrackedArrayList<E>>> iterator = this.snapshots.iterator();
            while (iterator.hasNext()) {
                TrackedArrayList snapshot = (TrackedArrayList)iterator.next().get();
                if (snapshot == null) {
                    iterator.remove();
                    continue;
                }
                shots.add(snapshot);
            }
        }
        return shots;
    }

    @Override
    public void setModified(boolean modified) {
        this.modified = modified;
        if (!modified) {
            this.added = false;
            this.removed = false;
            this.removedObjectsFiltered = false;
            this.removedObjects = null;
        }
    }

    @Override
    public boolean isModified() {
        return this.modified || this.isSomeAdded() || this.isSomeRemoved();
    }

    @Override
    public boolean isElementModified() {
        for (Object element : this) {
            if (!(element instanceof Modifiable) || !((Modifiable)element).isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setImmutable(boolean immutable, boolean withElements) {
        if (immutable) {
            this.assertNotSomeRemoved();
        }
        super.setImmutable(immutable, withElements);
    }

    @Override
    public void setFinallyImmutable(boolean withElements) {
        this.assertNotSomeRemoved();
        super.setFinallyImmutable(withElements);
    }

    private void assertNotSomeRemoved() {
        if (this.removedObjects != null && !this.removedObjects.isEmpty()) {
            throw new ImmutableException("list already contains removed objects, cannot make it immutable");
        }
    }

    @Override
    public boolean isSomeRemoved() {
        this.filterRemovedObjects();
        return this.removed;
    }

    @Override
    public boolean isSomeAdded() {
        return this.added;
    }

    @Override
    public Collection<E> getRemovedObjects() {
        this.filterRemovedObjects();
        return this.removedObjects();
    }

    protected void addRemovedObject(E object) {
        if (object != null) {
            this.assertMutable();
            if (this.removedObjects().add(object)) {
                this.fireRemoved(object);
            }
            this.removed = true;
            this.removedObjectsFiltered = false;
        }
    }

    protected void addRemovedObjects(Collection<? extends E> objects) {
        for (E o : objects) {
            this.addRemovedObject(o);
        }
    }

    protected void removeRemovedObject(E object) {
        if (this.removedObjects != null && object != null) {
            this.removedObjects.remove(object);
        }
    }

    protected void removeRemovedObjects(Collection<? extends E> objects) {
        for (E obj : objects) {
            this.removeRemovedObject(obj);
        }
    }

    @Override
    protected void assertMutable() {
        super.assertMutable();
        if (this.isSnapshot()) {
            throw new ImmutableException("list is a snapshot");
        }
    }

    @Override
    public boolean add(E element) {
        if (super.add(element)) {
            this.added = true;
            this.removeRemovedObject(element);
            this.fireAdded(element);
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.removeRemovedObject(element);
        this.added = true;
        this.fireAdded(element);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (super.addAll(collection)) {
            this.added = true;
            this.removeRemovedObjects(collection);
            if (this.listeners != null) {
                for (E element : collection) {
                    this.fireAdded(element);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        if (super.addAll(index, collection)) {
            this.added = true;
            this.removeRemovedObjects(collection);
            if (this.listeners != null) {
                for (E element : collection) {
                    this.fireAdded(element);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.addRemovedObjects(this);
        super.clear();
    }

    @Override
    public E remove(int index) {
        Object obj = super.remove(index);
        this.addRemovedObject(obj);
        return obj;
    }

    @Override
    public boolean remove(Object obj) {
        int ndx = this.indexOf(obj);
        if (ndx >= 0) {
            this.remove(ndx);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean someRemoved = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!collection.contains(obj)) continue;
            iter.remove();
            someRemoved = true;
        }
        return someRemoved;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean someRemoved = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (collection.contains(obj)) continue;
            iter.remove();
            this.addRemovedObject(obj);
            someRemoved = true;
        }
        return someRemoved;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        this.stream().filter(filter).forEach(this::addRemovedObject);
        return super.removeIf(filter);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        int max = this.size();
        if (fromIndex < max) {
            if (toIndex > max) {
                toIndex = max;
            }
            if (toIndex - fromIndex > 0) {
                this.addRemovedObjects(this.subList(fromIndex, toIndex));
                super.removeRange(fromIndex, toIndex);
            }
        }
    }

    @Override
    public E set(int index, E element) {
        E obj = super.set(index, element);
        if (obj != element) {
            this.addRemovedObject(obj);
            this.removeRemovedObject(element);
            this.fireAdded(element);
            this.added = true;
        }
        return obj;
    }

    @Override
    public boolean addIfAbsent(E element) {
        if (!this.contains(element)) {
            this.add(element);
            return true;
        }
        return false;
    }

    @Override
    public void addBlunt(E element) {
        super.add(element);
    }

    @Override
    public boolean removeBlunt(E element) {
        return super.remove(element);
    }

    @Override
    public E removeBlunt(int index) {
        return super.remove(index);
    }

    @Override
    public E replace(int index, E element) {
        this.filterRemovedObjects();
        return super.set(index, element);
    }

    @Override
    public void addListener(TrackedListListener<E> listener) {
        this.getListeners().add(listener);
    }

    @Override
    public boolean removeListener(TrackedListListener<E> listener) {
        boolean listenerRemoved = false;
        Iterator<TrackedListListener<E>> iter = this.getListeners().iterator();
        while (iter.hasNext()) {
            TrackedListListener<E> l = iter.next();
            if (!listener.equals(l)) continue;
            iter.remove();
            listenerRemoved = true;
        }
        return listenerRemoved;
    }

    private void init() {
        this.removedObjects = null;
        this.snapshots = null;
        this.elementSnapshots = null;
        this.modified = false;
        this.removed = false;
        this.removedObjectsFiltered = false;
        this.added = false;
        this.immutable = false;
    }

    private void fireAdded(E object) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (TrackedListListener<E> listener : this.getListeners()) {
                listener.added(object);
            }
        }
    }

    private void fireRemoved(E object) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (TrackedListListener<E> listener : this.getListeners()) {
                listener.removed(object);
            }
        }
    }

    private List<TrackedListListener<E>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<TrackedListListener<E>>();
        }
        return this.listeners;
    }

    private void filterRemovedObjects() {
        if (!this.removedObjectsFiltered) {
            if (this.removedObjects != null && !this.removedObjects.isEmpty()) {
                this.removedObjects.removeAll(this);
                this.removed = !this.removedObjects.isEmpty();
            }
            this.removedObjectsFiltered = true;
        }
    }

    private int getSnapshotIndex(TrackedList<E> snapshot) {
        if (this.snapshots != null) {
            int index = 0;
            Iterator<WeakReference<TrackedArrayList<E>>> iterator = this.snapshots.iterator();
            while (iterator.hasNext()) {
                TrackedArrayList shot = (TrackedArrayList)iterator.next().get();
                if (shot == null) {
                    iterator.remove();
                    continue;
                }
                if (shot == snapshot) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    private Set<E> removedObjects() {
        if (this.removedObjects == null) {
            this.removedObjects = new LinkedHashSet();
        }
        return this.removedObjects;
    }
}

