/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.util.Collection;
import java.util.List;
import org.tentackle.misc.ImmutableCollection;
import org.tentackle.misc.Snapshotable;
import org.tentackle.misc.TrackedArrayList;
import org.tentackle.misc.TrackedListListener;

public interface TrackedList<E>
extends List<E>,
ImmutableCollection<E>,
Snapshotable<TrackedList<E>> {
    public static <E> TrackedList<E> createSnapshot(TrackedList<E> list) {
        return list == null ? null : (TrackedList)list.createSnapshot();
    }

    public static <E> TrackedList<E> revertToSnapshot(TrackedList<E> list, TrackedList<E> snapshot) {
        TrackedArrayList revertedList = null;
        if (snapshot != null) {
            boolean asCopy = list == null;
            revertedList = asCopy ? new TrackedArrayList() : list;
            revertedList.setCopy(asCopy);
            revertedList.revertToSnapshot(snapshot);
        }
        return revertedList;
    }

    public void setModified(boolean var1);

    public boolean isModified();

    public boolean isElementModified();

    public boolean isSomeRemoved();

    public boolean isSomeAdded();

    public Collection<E> getRemovedObjects();

    public E replace(int var1, E var2);

    public boolean addIfAbsent(E var1);

    public void addBlunt(E var1);

    public boolean removeBlunt(E var1);

    public E removeBlunt(int var1);

    public void addListener(TrackedListListener<E> var1);

    public boolean removeListener(TrackedListListener<E> var1);
}

