/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.misc;

import java.io.File;
import java.util.function.Supplier;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.log.Logger;

public class UserHomeJavaDir {
    private static final Logger LOGGER = Logger.get(UserHomeJavaDir.class);
    private static volatile boolean initialized;
    private static volatile File cacheDir;

    public static File getDirectory() {
        if (!initialized) {
            cacheDir = new File(System.getProperty("tentackle.user.home.java.dir", System.getProperty("user.home")), ".java" + File.separator + "tentackle");
            UserHomeJavaDir.checkDir(cacheDir);
            initialized = true;
        }
        return cacheDir;
    }

    public static File getDirectory(String ... subDirNames) {
        File subDir = UserHomeJavaDir.getDirectory();
        for (String subDirName : subDirNames) {
            subDir = new File(UserHomeJavaDir.getDirectory(), subDirName);
        }
        UserHomeJavaDir.checkDir(subDir);
        return subDir;
    }

    private static void checkDir(File dir) {
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = dir::getAbsolutePath;
                LOGGER.info("created directory {0}", supplierArray);
            } else {
                throw new TentackleRuntimeException("couldn't create directory " + dir.getAbsolutePath());
            }
        }
        if (!dir.canWrite()) {
            throw new TentackleRuntimeException("directory " + dir.getAbsolutePath() + " is not writable");
        }
    }

    private UserHomeJavaDir() {
    }
}

