/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.prefs;

import java.util.Objects;
import java.util.prefs.BackingStoreException;
import org.tentackle.prefs.PersistedPreferences;
import org.tentackle.prefs.PersistedPreferencesFactory;

public abstract class CompositePreferences {
    private final boolean systemOnly;
    private PersistedPreferences userPrefs;
    private PersistedPreferences systemPrefs;

    public CompositePreferences(boolean systemOnly) {
        this.systemOnly = systemOnly;
    }

    public boolean isSystemOnly() {
        return this.systemOnly;
    }

    public PersistedPreferences getUserPrefs() {
        if (!this.systemOnly && this.userPrefs == null) {
            this.userPrefs = PersistedPreferencesFactory.getInstance().userNodeForPackage(this.getClass());
        }
        return this.userPrefs;
    }

    public PersistedPreferences getSystemPrefs() {
        if (this.systemPrefs == null) {
            this.systemPrefs = PersistedPreferencesFactory.getInstance().systemNodeForPackage(this.getClass());
        }
        return this.systemPrefs;
    }

    public void flush() throws BackingStoreException {
        if (!this.systemOnly) {
            this.getUserPrefs().flush();
        }
        this.getSystemPrefs().flush();
    }

    public void sync() throws BackingStoreException {
        if (!this.systemOnly) {
            this.getUserPrefs().sync();
        }
        this.getSystemPrefs().sync();
    }

    public String getString(String key) {
        String val = null;
        if (!this.systemOnly) {
            val = this.getUserPrefs().get(key, null);
        }
        if (val == null) {
            val = this.getSystemPrefs().get(key, null);
        }
        return val;
    }

    public String getString(String key, String def) {
        String val = this.getString(key);
        return val == null ? def : val;
    }

    public void setString(String key, String val) {
        if (!this.systemOnly) {
            if (val == null || Objects.equals(val, this.getSystemPrefs().get(key, null))) {
                this.getUserPrefs().remove(key);
            } else {
                this.getUserPrefs().put(key, val);
            }
        } else if (val == null) {
            this.getSystemPrefs().remove(key);
        } else {
            this.getSystemPrefs().put(key, val);
        }
    }

    public Integer getInteger(String key) {
        String val = this.getString(key);
        return val == null ? null : Integer.valueOf(val);
    }

    public int getInt(String key, int def) {
        Integer val = this.getInteger(key);
        return val == null ? def : val;
    }

    public void setInteger(String key, Integer val) {
        this.setString(key, val == null ? null : val.toString());
    }

    public Long getALong(String key) {
        String val = this.getString(key);
        return val == null ? null : Long.valueOf(val);
    }

    public long getLong(String key, long def) {
        Long val = this.getALong(key);
        return val == null ? def : val;
    }

    public void setLong(String key, Long val) {
        this.setString(key, val == null ? null : val.toString());
    }

    public Float getAFloat(String key) {
        String val = this.getString(key);
        return val == null ? null : Float.valueOf(val);
    }

    public float getFloat(String key, float def) {
        Float val = this.getAFloat(key);
        return val == null ? def : val.floatValue();
    }

    public void setFloat(String key, Float val) {
        this.setString(key, val == null ? null : val.toString());
    }

    public Double getADouble(String key) {
        String val = this.getString(key);
        return val == null ? null : Double.valueOf(val);
    }

    public double getDouble(String key, double def) {
        Double val = this.getADouble(key);
        return val == null ? def : val;
    }

    public void setDouble(String key, Double val) {
        this.setString(key, val == null ? null : val.toString());
    }

    public Boolean getABoolean(String key) {
        String val = this.getString(key);
        return val == null ? null : Boolean.valueOf(val);
    }

    public boolean getBoolean(String key, boolean def) {
        Boolean val = this.getABoolean(key);
        return val == null ? def : val;
    }

    public void setBoolean(String key, Boolean val) {
        this.setString(key, val == null ? null : val.toString());
    }

    public byte[] getByteArray(String key) {
        byte[] val = null;
        if (!this.systemOnly) {
            val = this.getUserPrefs().getByteArray(key, null);
        }
        if (val == null) {
            val = this.getSystemPrefs().getByteArray(key, null);
        }
        return val;
    }

    public byte[] getByteArray(String key, byte[] def) {
        byte[] val = this.getByteArray(key);
        return val == null ? def : val;
    }

    public void setByteArray(String key, byte[] val) {
        if (!this.systemOnly) {
            if (val == null || this.areByteArraysEqual(val, this.getSystemPrefs().getByteArray(key, null))) {
                this.getUserPrefs().remove(key);
            } else {
                this.getUserPrefs().putByteArray(key, val);
            }
        } else if (val == null) {
            this.getSystemPrefs().remove(key);
        } else {
            this.getSystemPrefs().putByteArray(key, val);
        }
    }

    private boolean areByteArraysEqual(byte[] b1, byte[] b2) {
        if (b1 == null) {
            return b2 == null;
        }
        if (b2 == null) {
            return false;
        }
        if (b1.length == b2.length) {
            for (int i = 0; i < b1.length; ++i) {
                if (b1[i] == b2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

