/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.log.Logger;

public abstract class AbstractClassMapper<S> {
    private static final Logger LOGGER = Logger.get(AbstractClassMapper.class);
    private final ConcurrentHashMap<String, S> classMap = new ConcurrentHashMap();
    private final String name;

    public AbstractClassMapper(String name) {
        this.name = name;
    }

    public abstract String[] getPackageNames();

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public abstract Map<String, S> getNameMap();

    private S mapInterfaces(Class<?> clazz) {
        S result = null;
        for (Class<?> interfaze : clazz.getInterfaces()) {
            result = this.getNameMap().get(interfaze.getName());
            if (result != null || (result = (S)this.mapInterfaces(interfaze)) != null) break;
        }
        return result;
    }

    private S mapName(String className, boolean lenient) throws ClassNotFoundException {
        if (lenient) {
            Class<?> clazz = null;
            boolean isInterface = false;
            while (className != null) {
                S value = this.getNameMap().get(className);
                if (value != null) {
                    return value;
                }
                if (clazz == null) {
                    clazz = Class.forName(className);
                    isInterface = clazz.isInterface();
                }
                if (isInterface) {
                    return this.mapInterfaces(clazz);
                }
                if ((clazz = clazz.getSuperclass()) == null) break;
                className = clazz.getName();
            }
            return null;
        }
        return this.getNameMap().get(className);
    }

    private S mapNameWithPackages(String className, boolean lenient) throws ClassNotFoundException {
        if (!className.startsWith("[") && className.indexOf(46) < 0) {
            String[] packageNames = this.getPackageNames();
            if (packageNames != null) {
                for (String packageName : packageNames) {
                    S result = this.mapName(packageName + "." + className, lenient);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
        return this.mapName(className, lenient);
    }

    public S map(String className, boolean lenient) throws ClassNotFoundException {
        S mappedClazz = this.classMap.get(className);
        if (mappedClazz == null) {
            mappedClazz = this.mapNameWithPackages(className, lenient);
            if (mappedClazz == null) {
                throw new ClassNotFoundException("no " + this.name + " mapping for '" + className + (String)(lenient ? "' in packages " + this.getPackageNamesAsString() : "'"));
            }
            if (this.classMap.put(className, mappedClazz) == null) {
                LOGGER.info("{0}: added {1} -> {2}", this.name, className, mappedClazz.toString());
            }
        }
        LOGGER.fine("{0}: mapped {1} -> {2}", this.name, className, mappedClazz.toString());
        return mappedClazz;
    }

    private String getPackageNamesAsString() {
        StringBuilder buf = new StringBuilder("[");
        String[] packageNames = this.getPackageNames();
        if (packageNames != null) {
            boolean first = true;
            for (String packageName : packageNames) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(packageName);
            }
        }
        buf.append("]");
        return buf.toString();
    }
}

