/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.reflect.Interceptor;

public abstract class AbstractInterceptor
implements Interceptor {
    private Interceptor chainedInterceptor;
    private Method chainedMethod;
    private Annotation annotation;

    @Override
    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public void setChainedInterceptor(Interceptor chainedInterceptor) {
        this.chainedInterceptor = chainedInterceptor;
        try {
            this.chainedMethod = chainedInterceptor.getClass().getMethod("invoke", Object.class, Method.class, Object[].class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new TentackleRuntimeException("cannot determine the 'invoke' method of the chained interceptor " + chainedInterceptor.getClass().getName(), (Throwable)e);
        }
    }

    @Override
    public Interceptor getChainedInterceptor() {
        return this.chainedInterceptor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (this.chainedMethod != null) {
                return this.proceed(this.chainedInterceptor, this.chainedMethod, new Object[]{proxy, method, args}, proxy, method, args);
            }
            return this.proceed(proxy, method, args, proxy, method, args);
        }
        catch (InvocationTargetException ix) {
            throw ix.getCause();
        }
    }

    public abstract Object proceed(Object var1, Method var2, Object[] var3, Object var4, Method var5, Object[] var6) throws Throwable;
}

