/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.reflect.AbstractClassMapper;

public class ClassToServicesMapper<T>
extends AbstractClassMapper<Set<String>> {
    private final Map<String, Set<Class<T>>> classMap;
    private final Map<String, Set<String>> nameMap;
    private final String[] packageNames;

    public ClassToServicesMapper(String name, Map<String, Set<String>> nameMap, String[] packageNames) {
        super(name);
        this.packageNames = packageNames;
        this.nameMap = nameMap;
        this.classMap = new ConcurrentHashMap<String, Set<Class<T>>>();
    }

    @Override
    public Map<String, Set<String>> getNameMap() {
        return this.nameMap;
    }

    @Override
    public String[] getPackageNames() {
        return this.packageNames;
    }

    public Set<Class<T>> mapClass(String className, boolean lenient) throws ClassNotFoundException {
        Set<Class<T>> clazzes = this.classMap.get(className);
        if (clazzes == null) {
            Set mappedNames = (Set)this.map(className, lenient);
            clazzes = new HashSet<Class<T>>();
            for (String name : mappedNames) {
                clazzes.add(Class.forName(name));
            }
            this.classMap.put(className, clazzes);
        }
        return clazzes;
    }
}

