/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.ServiceFactory;
import org.tentackle.log.Logger;
import org.tentackle.reflect.AbstractClassMapper;
import org.tentackle.reflect.ClassMapper;

public class DefaultClassMapper
extends AbstractClassMapper<String>
implements ClassMapper {
    private static final Logger LOGGER = Logger.get(DefaultClassMapper.class);
    private Class<?> defaultClass;
    private final ClassLoader classLoader;
    private final Map<String, Class<?>> classMap;
    private final Map<String, String> nameMap;
    private final String[] packageNames;

    public DefaultClassMapper(String name, ClassLoader classLoader, Map<String, String> nameMap, String[] packageNames) {
        super(name);
        this.classLoader = classLoader;
        this.packageNames = packageNames;
        this.nameMap = nameMap;
        this.classMap = new ConcurrentHashMap();
    }

    public DefaultClassMapper(String name, ClassLoader classLoader, Properties nameProps, String[] packageNames) {
        this(name, classLoader, new HashMap<String, String>(), packageNames);
        for (String key : nameProps.stringPropertyNames()) {
            this.nameMap.put(key, nameProps.getProperty(key));
        }
    }

    public DefaultClassMapper(String name, String mappedServiceName) {
        this(name, ServiceFactory.getClassLoader((String)"META-INF/mapped-services/", (String)mappedServiceName), ServiceFactory.getServiceFinder().createNameMap(mappedServiceName), null);
    }

    public DefaultClassMapper(String name, Class<?> mappedClass) {
        this(name, mappedClass.getName());
    }

    @Override
    public Map<String, String> getNameMap() {
        return this.nameMap;
    }

    @Override
    public String[] getPackageNames() {
        return this.packageNames;
    }

    @Override
    public Class<?> getDefaultClass() {
        return this.defaultClass;
    }

    @Override
    public void setDefaultClass(Class<?> defaultClass) {
        this.defaultClass = defaultClass;
    }

    private Class<?> mapClass(String className, boolean lenient) throws ClassNotFoundException {
        Class<?> clazz = this.classMap.get(className);
        if (clazz == null) {
            String mappedName;
            try {
                mappedName = (String)this.map(className, lenient);
            }
            catch (ClassNotFoundException cx) {
                if (this.defaultClass != null) {
                    LOGGER.fine("{0} -> using default {0}", cx.getMessage(), this.defaultClass);
                    this.classMap.put(className, this.defaultClass);
                    return this.defaultClass;
                }
                throw cx;
            }
            clazz = Class.forName(mappedName, true, this.classLoader);
            this.classMap.put(className, clazz);
        }
        return clazz;
    }

    @Override
    public Class<?> map(Class<?> clazz) throws ClassNotFoundException {
        return this.map(clazz.getName());
    }

    @Override
    public Class<?> map(String className) throws ClassNotFoundException {
        return this.mapClass(className, false);
    }

    @Override
    public Class<?> mapLenient(Class<?> clazz) throws ClassNotFoundException {
        return this.mapLenient(clazz.getName());
    }

    @Override
    public Class<?> mapLenient(String className) throws ClassNotFoundException {
        return this.mapClass(className, true);
    }
}

