/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.tentackle.common.Service;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.reflect.ClassMapper;
import org.tentackle.reflect.Interceptable;
import org.tentackle.reflect.InterceptableFactory;
import org.tentackle.reflect.InterceptableInvocationHandler;

@Service(value=InterceptableFactory.class)
public class DefaultInterceptableFactory
implements InterceptableFactory {
    private final ClassMapper classMapper = ClassMapper.create("interception", Interceptable.class);

    @Override
    public <T extends Interceptable & Serializable> T createInterceptable(Class<T> clazz) {
        try {
            InterceptableInvocationHandler<Interceptable> handler = new InterceptableInvocationHandler<Interceptable>(this.classMapper, clazz);
            Interceptable instance = (Interceptable)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
            handler.setupDelegate(instance, clazz);
            return (T)instance;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TentackleRuntimeException("cannot create interceptable for class " + clazz, (Throwable)e);
        }
    }
}

