/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.reflect.ClassMapper;
import org.tentackle.reflect.EffectiveClassProvider;
import org.tentackle.reflect.Interceptable;
import org.tentackle.reflect.InterceptableMethod;
import org.tentackle.reflect.InterceptionUtilities;
import org.tentackle.reflect.Interceptor;
import org.tentackle.reflect.Mixin;

public class InterceptableInvocationHandler<T extends Interceptable & Serializable>
implements InvocationHandler {
    private static final ConcurrentHashMap<Method, InterceptableMethod> METHOD_CACHE = new ConcurrentHashMap();
    private static final Method GETEFFECTIVECLASS_METHOD;
    private static final Method GETEFFECTIVESUPERCLASSES_METHOD;
    private final Class<T> clazz;
    private final Mixin<T, T> mixin;

    public InterceptableInvocationHandler(ClassMapper mapper, Class<T> clazz) throws ClassNotFoundException {
        this.clazz = clazz;
        this.mixin = new Mixin(mapper, clazz, Interceptable.class);
    }

    public void setupDelegate(T proxy, Class<T> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.mixin.createDelegate(new Class[]{clazz}, new Object[]{proxy});
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.equals(GETEFFECTIVECLASS_METHOD)) {
            return this.clazz;
        }
        if (method.equals(GETEFFECTIVESUPERCLASSES_METHOD)) {
            ArrayList list = new ArrayList();
            for (Class<?> ifClass : this.clazz.getInterfaces()) {
                if (!Interceptable.class.isAssignableFrom(ifClass)) continue;
                list.add(ifClass);
            }
            return list;
        }
        InterceptableMethod delegateMethod = METHOD_CACHE.get(method);
        if (delegateMethod == null) {
            Method implMethod = ((Interceptable)this.mixin.getDelegate()).getClass().getMethod(method.getName(), method.getParameterTypes());
            Interceptor interceptor = InterceptionUtilities.getInstance().findInterceptors(this.clazz, method, implMethod);
            delegateMethod = new InterceptableMethod(method, implMethod, interceptor);
            METHOD_CACHE.put(method, delegateMethod);
        }
        return delegateMethod.invoke(this.mixin.getDelegate(), args);
    }

    static {
        try {
            GETEFFECTIVECLASS_METHOD = EffectiveClassProvider.class.getDeclaredMethod("getEffectiveClass", new Class[0]);
            GETEFFECTIVESUPERCLASSES_METHOD = EffectiveClassProvider.class.getDeclaredMethod("getEffectiveSuperClasses", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

