/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tentackle.reflect.Interceptor;

public class InterceptableMethod {
    private final Method method;
    private final Method delegateMethod;
    private final Interceptor interceptor;

    public InterceptableMethod(Method method, Method delegateMethod, Interceptor interceptor) {
        this.method = method;
        this.delegateMethod = delegateMethod;
        this.interceptor = interceptor;
    }

    public Method getMethod() {
        return this.method;
    }

    public Method getDelegateMethod() {
        return this.delegateMethod;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Object invoke(Object delegate, Object[] args) throws Throwable {
        try {
            if (this.interceptor != null) {
                return this.interceptor.invoke(delegate, this.delegateMethod, args);
            }
            return this.delegateMethod.invoke(delegate, args);
        }
        catch (InvocationTargetException ix) {
            throw ix.getCause();
        }
    }
}

