/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.reflect.Interceptable;
import org.tentackle.reflect.InterceptableMethod;
import org.tentackle.reflect.InterceptableMethodInvoker;
import org.tentackle.reflect.InterceptionUtilities;
import org.tentackle.reflect.ReflectionHelper;

public class InterceptableMethodCache {
    private static final ConcurrentHashMap<Class<? extends Interceptable>, InterceptableMethodCache> CACHE_MAP = new ConcurrentHashMap();
    private final Class<? extends Interceptable> clazz;
    private final ConcurrentHashMap<Method, InterceptableMethod> methodCache;

    public static InterceptableMethodCache getCache(Class<? extends Interceptable> effectiveClass) {
        return CACHE_MAP.computeIfAbsent(effectiveClass, InterceptableMethodCache::new);
    }

    public InterceptableMethodCache(Class<? extends Interceptable> clazz) {
        this.clazz = clazz;
        this.methodCache = new ConcurrentHashMap();
    }

    public String toString() {
        return ReflectionHelper.getClassBaseName(this.getClass()) + "(" + ReflectionHelper.getClassBaseName(this.clazz) + ")";
    }

    public Object invoke(InterceptableMethodInvoker invoker, Interceptable delegate, Method method, Object[] args) throws Throwable {
        InterceptableMethod delegateMethod = this.methodCache.computeIfAbsent(method, m -> InterceptionUtilities.getInstance().createInterceptableMethod(this.clazz, (Class<? extends Interceptable>)delegate.getClass(), (Method)m));
        return invoker.invoke(delegate, delegateMethod, args);
    }
}

