/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.lang.reflect.Method;
import java.util.Collection;
import org.tentackle.common.StringHelper;
import org.tentackle.log.Logger;
import org.tentackle.log.MethodStatistics;
import org.tentackle.misc.Duration;
import org.tentackle.reflect.InterceptableMethod;
import org.tentackle.reflect.ReflectionHelper;

public class InterceptableMethodInvoker
extends MethodStatistics {
    private static final Logger LOGGER = Logger.get(InterceptableMethodInvoker.class);
    private boolean collectStatistics;
    private boolean logInvocations;
    private boolean logInvocationDetails;
    private long logMinDurationMillis;
    private int logMinReturnedCollectionSize;
    private boolean durationNecessary;
    private final String name;

    public InterceptableMethodInvoker(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isCollectingStatistics() {
        return this.collectStatistics;
    }

    public void setCollectingStatistics(boolean collectStatistics) {
        this.collectStatistics = collectStatistics;
        this.updateDurationNecessary();
    }

    public boolean isLoggingInvocations() {
        return this.logInvocations;
    }

    public void setLoggingInvocations(boolean logInvocations) {
        this.logInvocations = logInvocations;
        this.updateDurationNecessary();
    }

    public boolean isLoggingInvocationDetails() {
        return this.logInvocationDetails;
    }

    public void setLoggingInvocationDetails(boolean logInvocationDetails) {
        this.logInvocationDetails = logInvocationDetails;
    }

    public long getLogMinDurationMillis() {
        return this.logMinDurationMillis;
    }

    public void setLogMinDurationMillis(long logMinDurationMillis) {
        this.logMinDurationMillis = logMinDurationMillis;
        this.updateDurationNecessary();
    }

    public int getLogMinReturnedCollectionSize() {
        return this.logMinReturnedCollectionSize;
    }

    public void setLogMinReturnedCollectionSize(int logMinReturnedCollectionSize) {
        this.logMinReturnedCollectionSize = logMinReturnedCollectionSize;
        this.updateDurationNecessary();
    }

    public Object invoke(Object delegate, InterceptableMethod delegateMethod, Object[] args) throws Throwable {
        if (this.durationNecessary) {
            Duration duration = new Duration();
            Object retval = delegateMethod.invoke(delegate, args);
            duration.end();
            this.log(delegate, delegateMethod.getMethod(), args, retval, duration);
            return retval;
        }
        return delegateMethod.invoke(delegate, args);
    }

    public void logStatistics(Logger.Level level, boolean clear) {
        this.logStatistics(this.toString(), level, "    >" + this.name + "-Stats: ", clear);
    }

    protected void log(Object delegate, Method method, Object[] args, Object retval, Duration duration) {
        boolean collectionSizeExceeded;
        boolean durationExceeded;
        boolean bl = durationExceeded = this.logMinDurationMillis > 0L && duration.millis() > (double)this.logMinDurationMillis;
        if (this.collectStatistics) {
            this.countMethodInvocation(method, delegate.getClass(), duration);
        }
        int collectionSize = retval instanceof Collection ? ((Collection)retval).size() : 0;
        boolean bl2 = collectionSizeExceeded = this.logMinReturnedCollectionSize > 0 && collectionSize > this.logMinReturnedCollectionSize;
        if (durationExceeded || collectionSizeExceeded) {
            LOGGER.warning(() -> {
                StringBuilder buf = this.createInvocationLog(delegate, method, args, retval, duration, collectionSize);
                if (durationExceeded) {
                    buf.insert(0, ">>> duration exceeded:\n");
                }
                if (collectionSizeExceeded) {
                    buf.insert(0, ">>> collection size exceeded:\n");
                }
                return buf.toString();
            });
        } else if (this.logInvocationDetails) {
            LOGGER.info(() -> this.createInvocationLog(delegate, method, args, retval, duration, collectionSize).toString());
        }
    }

    private StringBuilder createInvocationLog(Object delegate, Method method, Object[] args, Object retval, Duration duration, int collectionSize) {
        StringBuilder buf = new StringBuilder();
        if (this.logInvocationDetails) {
            buf.append(ReflectionHelper.getClassBaseName(delegate.getClass())).append(": ").append(ReflectionHelper.getClassBaseName(method.getDeclaringClass())).append('.').append(method.getName()).append('(');
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        buf.append(',');
                    }
                    buf.append(StringHelper.objectToLoggableString((Object)args[i]));
                }
            }
            buf.append(") = ").append(StringHelper.objectToLoggableString((Object)retval)).append(" {").append(duration.millisToString()).append("ms");
            if (collectionSize > 0) {
                buf.append(", ").append(collectionSize).append(" items");
            }
            buf.append('}');
        } else {
            buf.append(ReflectionHelper.getClassBaseName(method.getDeclaringClass())).append('.').append(method.getName()).append(" [").append(duration.millisToString()).append("ms]");
        }
        return buf;
    }

    private void updateDurationNecessary() {
        this.durationNecessary = this.logInvocations || this.collectStatistics || this.logMinDurationMillis > 0L || this.logMinReturnedCollectionSize > 0;
    }
}

