/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.reflect.Interceptable;
import org.tentackle.reflect.InterceptableMethod;
import org.tentackle.reflect.Interception;
import org.tentackle.reflect.InterceptionUtilitiesHolder;
import org.tentackle.reflect.Interceptor;
import org.tentackle.reflect.ReflectionHelper;

@Service(value=InterceptionUtilities.class)
public class InterceptionUtilities {
    public static InterceptionUtilities getInstance() {
        return InterceptionUtilitiesHolder.INSTANCE;
    }

    public Interceptor findInterceptors(Class<?> clazz, Method method, Method implMethod) {
        Interception interception;
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.isInterface() && clazz.isAssignableFrom(declaringClass)) {
            for (Annotation annotation : method.getAnnotations()) {
                interception = annotation.annotationType().getAnnotation(Interception.class);
                if (interception == null) continue;
                interceptors.add(this.createInterceptor(interception, annotation));
            }
        }
        if (!(declaringClass = implMethod.getDeclaringClass()).isInterface() && clazz.isAssignableFrom(implMethod.getDeclaringClass())) {
            for (Annotation annotation : implMethod.getAnnotations()) {
                interception = annotation.annotationType().getAnnotation(Interception.class);
                if (interception == null) continue;
                interceptors.add(this.createInterceptor(interception, annotation));
            }
        }
        if (interceptors.size() > 1) {
            int ndx = interceptors.size() - 1;
            Interceptor chainedInterceptor = (Interceptor)interceptors.get(ndx);
            while (--ndx >= 0) {
                Interceptor interceptor = (Interceptor)interceptors.get(ndx);
                interceptor.setChainedInterceptor(chainedInterceptor);
                chainedInterceptor = interceptor;
            }
        }
        return interceptors.isEmpty() ? null : (Interceptor)interceptors.get(0);
    }

    private Interceptor createInterceptor(Interception interception, Annotation annotation) {
        Class<Interceptor> implClass = interception.implementedBy();
        try {
            if (implClass == Interceptor.class) {
                Map.Entry entry;
                if (!interception.implementedByName().isEmpty()) {
                    implClass = Class.forName(interception.implementedByName());
                } else if (!interception.implementedByService().isEmpty()) {
                    entry = ServiceFactory.getServiceFinder().findFirstServiceConfiguration(interception.implementedByService());
                    implClass = Class.forName((String)entry.getKey());
                } else {
                    entry = ServiceFactory.getServiceFinder().findFirstServiceConfiguration(annotation.annotationType().getName());
                    implClass = Class.forName((String)entry.getKey());
                }
            }
            Interceptor interceptor = implClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            interceptor.setAnnotation(annotation);
            return interceptor;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new TentackleRuntimeException("interceptor @" + annotation + " could not be created", (Throwable)ex);
        }
    }

    public InterceptableMethod createInterceptableMethod(Class<? extends Interceptable> clazz, Class<? extends Interceptable> delegateClazz, Method method) {
        Method implMethod;
        Method effectiveMethod = ReflectionHelper.findDeclaredMethod(clazz, method);
        try {
            implMethod = delegateClazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException nx) {
            throw new TentackleRuntimeException("cannot create interceptable method", (Throwable)nx);
        }
        Interceptor interceptor = this.findInterceptors(Interceptable.class, effectiveMethod, implMethod);
        return new InterceptableMethod(method, implMethod, interceptor);
    }
}

