/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.tentackle.log.Logger;

public class MethodCache {
    private static final Logger LOGGER = Logger.get(MethodCache.class);
    private final ConcurrentMap<Key, Method> methodMap;
    private String name;

    public MethodCache(String name) {
        if (name == null) {
            throw new NullPointerException("cache must be given a name");
        }
        this.name = name;
        this.methodMap = new ConcurrentHashMap<Key, Method>();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public Method getMethod(Class<?> clazz, Class<?> ... parameterTypes) {
        return (Method)this.methodMap.get(new Key(clazz, parameterTypes));
    }

    public Method addMethod(Method method, Class<?> clazz, Class<?> ... parameterTypes) {
        Key key = new Key(clazz, parameterTypes);
        Method oldMethod = this.methodMap.put(key, method);
        if (oldMethod == null) {
            LOGGER.info("added {0} for {1} to {2}", method, key, this);
        } else {
            LOGGER.info("replaced {0} by {1} for {2} to {3}", oldMethod, method, key, this);
        }
        return oldMethod;
    }

    public Method removeMethod(Class<?> clazz, Class<?> ... parameterTypes) {
        Key key = new Key(clazz, parameterTypes);
        Method method = (Method)this.methodMap.remove(key);
        if (method == null) {
            LOGGER.info("no such method for {0} in {1}", key, this);
        } else {
            LOGGER.info("removed {0} for {1} from {2}", method, key, this);
        }
        return method;
    }

    private static class Key {
        private final Class<?> clazz;
        private final Class<?>[] parameterTypes;

        private Key(Class<?> clazz, Class<?>[] parameterTypes) {
            this.clazz = clazz;
            this.parameterTypes = parameterTypes;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!(this.clazz == other.clazz || this.clazz != null && this.clazz.equals(other.clazz))) {
                return false;
            }
            return Arrays.deepEquals(this.parameterTypes, other.parameterTypes);
        }

        public int hashCode() {
            int hash = 3;
            hash = 83 * hash + (this.clazz != null ? this.clazz.hashCode() : 0);
            hash = 83 * hash + Arrays.deepHashCode(this.parameterTypes);
            return hash;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("class=");
            buf.append(this.clazz.getName());
            if (this.parameterTypes != null) {
                buf.append(", parameters=");
                boolean needComma = false;
                for (Class<?> type : this.parameterTypes) {
                    if (needComma) {
                        buf.append(',');
                    } else {
                        needComma = true;
                    }
                    buf.append(type.getName());
                }
            }
            return buf.toString();
        }
    }
}

