/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.tentackle.misc.Identifiable;

public class MethodInvocationKey {
    private final Method method;
    private final Object object;
    private final Object[] arguments;

    public MethodInvocationKey(Method method, Object object, Object ... arguments) {
        this.method = method;
        this.object = object;
        this.arguments = arguments;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getObject() {
        return this.object;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodInvocationKey other = (MethodInvocationKey)obj;
        if (!Objects.equals(this.method, other.method)) {
            return false;
        }
        if (!Objects.equals(this.object, other.object)) {
            return false;
        }
        return Arrays.deepEquals(this.arguments, other.arguments);
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + Objects.hashCode(this.method);
        hash = 47 * hash + Objects.hashCode(this.object);
        hash = 47 * hash + Arrays.deepHashCode(this.arguments);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.method);
        buf.append(" on ");
        if (this.object == null) {
            buf.append("<null>");
        } else {
            buf.append('{');
            buf.append(this.object instanceof Identifiable ? ((Identifiable)this.object).toGenericString() : this.object.toString());
            buf.append('}');
        }
        buf.append(" for {");
        buf.append(Arrays.toString(this.arguments));
        buf.append("}");
        return buf.toString();
    }
}

