/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.reflect.ClassMapper;

public class Mixin<T, M extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<Class<?>, Map<Class<?>, Boolean>> MATCH_CACHE = new ConcurrentHashMap();
    private Class<M> implClass;
    private Class<M> declClass;
    private M delegate;

    public Mixin(ClassMapper mapper, Class<T> clazz, Class<?> superInterface) throws ClassNotFoundException {
        if (clazz == null) {
            throw new NullPointerException("clazz must not be null");
        }
        if (mapper != null) {
            this.implClass = mapper.mapLenient(clazz);
            if (superInterface != null) {
                for (Class<?> interfaze : this.implClass.getInterfaces()) {
                    if (!superInterface.isAssignableFrom(interfaze)) continue;
                    this.declClass = interfaze;
                    break;
                }
                if (this.declClass == null) {
                    throw new IllegalArgumentException("implementation of " + clazz.getName() + " does not implement an extension of " + superInterface.getName());
                }
            } else {
                this.declClass = clazz;
            }
        } else {
            this.declClass = superInterface == null ? clazz : superInterface;
        }
    }

    public Mixin(Class<T> clazz, Class<?> superInterface) throws ClassNotFoundException {
        this(null, clazz, superInterface);
    }

    public boolean isDummy() {
        return this.implClass == null;
    }

    public void createDelegate(Class<?>[] constructorArgumentClasses, Object[] constructorArguments) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (!this.isDummy()) {
            Constructor<?>[] cons;
            for (Constructor<?> con : cons = this.implClass.getConstructors()) {
                Class<?>[] params = con.getParameterTypes();
                if (params.length != constructorArgumentClasses.length) continue;
                boolean allParmsMatch = true;
                for (int i = 0; i < params.length; ++i) {
                    if (constructorArgumentClasses[i].isAssignableFrom(params[i])) continue;
                    allParmsMatch = false;
                    break;
                }
                if (!allParmsMatch) continue;
                this.delegate = (Serializable)con.newInstance(constructorArguments);
                break;
            }
            if (this.delegate == null) {
                StringBuilder paramsAsString = new StringBuilder();
                for (Class<?> paramClass : constructorArgumentClasses) {
                    if (paramsAsString.length() > 0) {
                        paramsAsString.append(", ");
                    }
                    paramsAsString.append(paramClass.getName());
                }
                throw new NoSuchMethodException("no matching constructor found for " + this.implClass.getName() + "(" + paramsAsString + ")");
            }
        }
    }

    public void setDelegate(M delegate) {
        this.delegate = delegate;
    }

    public M getDelegate() {
        return this.delegate;
    }

    public Class<M> getDeclaringClass() {
        return this.declClass;
    }

    public Class<M> getImplementingClass() {
        return this.implClass;
    }

    public boolean matches(Class<?> clazz) {
        Map<Class<?>, Boolean> clazzMap = MATCH_CACHE.get(clazz);
        Boolean m = null;
        if (clazzMap == null) {
            clazzMap = new ConcurrentHashMap();
            MATCH_CACHE.put(clazz, clazzMap);
        } else {
            m = clazzMap.get(this.declClass);
        }
        if (m == null) {
            m = this.matchInterface(clazz, this.declClass);
            clazzMap.put(this.declClass, m);
        }
        return m;
    }

    private boolean matchInterface(Class<?> clazz, Class<?> interfaze) {
        if (clazz.equals(interfaze)) {
            return true;
        }
        for (Class<?> superInterface : interfaze.getInterfaces()) {
            if (!this.matchInterface(clazz, superInterface)) continue;
            return true;
        }
        return false;
    }
}

