/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;

public final class ReflectionHelper {
    private static final Map<Class<?>, Class<?>> PRIMITIVES = new HashMap();
    private static final Map<Class<?>, Class<?>> WRAPPERS;

    public static String getClassBaseName(String str) {
        return StringHelper.lastAfter((String)str, (char)'.');
    }

    public static String getClassBaseName(Class<?> clazz) {
        return ReflectionHelper.getClassBaseName(clazz.getName());
    }

    public static String getPackageName(String str) {
        int ndx = str.lastIndexOf(46);
        return ndx > 0 ? str.substring(0, ndx) : null;
    }

    public static String getPackageName(Class<?> clazz) {
        return ReflectionHelper.getPackageName(clazz.getName());
    }

    public static String methodToString(Method method) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(ReflectionHelper.getClassBaseName(method.getDeclaringClass())).append('.');
            sb.append(method.getName()).append('(');
            Class<?>[] params = method.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(ReflectionHelper.getClassBaseName(params[j]));
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        catch (RuntimeException e) {
            return "<" + e + ">";
        }
    }

    public static String makeDeclareString(String classname) {
        if (classname.startsWith("[")) {
            int i;
            StringBuilder buf = new StringBuilder();
            int len = classname.length();
            for (i = 0; i < len && classname.charAt(i) == '['; ++i) {
                buf.append("[]");
            }
            String type = classname.substring(i);
            if (type.endsWith(";")) {
                type = type.substring(0, len - 1);
            } else if ("Z".equals(type)) {
                type = "boolean";
            } else if ("B".equals(type)) {
                type = "byte";
            } else if ("C".equals(type)) {
                type = "char";
            } else if ("D".equals(type)) {
                type = "double";
            } else if ("F".equals(type)) {
                type = "float";
            } else if ("I".equals(type)) {
                type = "int";
            } else if ("J".equals(type)) {
                type = "long";
            } else if ("S".equals(type)) {
                type = "short";
            }
            buf.insert(0, type);
            return buf.toString();
        }
        return classname;
    }

    public static Class<?> primitiveToWrapperClass(Class<?> primitiveClass) {
        Class<?> wrapperClass = PRIMITIVES.get(primitiveClass);
        if (wrapperClass == null) {
            throw new ClassCastException("not a primitive: " + primitiveClass);
        }
        return wrapperClass;
    }

    public static Class<?> wrapperToPrimitiveClass(Class<?> wrapperClass) {
        Class<?> primitiveClass = WRAPPERS.get(wrapperClass);
        if (primitiveClass == null) {
            throw new ClassCastException("not a wrapper: " + wrapperClass);
        }
        return primitiveClass;
    }

    public static boolean isAssignableFrom(Class<?> clazz, Class<?>[] superClasses, boolean all) {
        if (clazz != null && superClasses != null) {
            for (Class<?> superClass : superClasses) {
                if (superClass.isAssignableFrom(clazz)) {
                    if (all) continue;
                    return true;
                }
                if (!all) continue;
                return false;
            }
            return all;
        }
        return true;
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<Annotation>[] annotations, boolean all) {
        if (clazz != null && annotations != null) {
            for (Class<Annotation> annotation : annotations) {
                if (clazz.isAnnotationPresent(annotation)) {
                    if (all) continue;
                    return true;
                }
                if (!all) continue;
                return false;
            }
            return all;
        }
        return true;
    }

    public static Field[] getAllFields(Class<?> clazz, Class<?>[] boundingClasses, boolean boundToAll, Class<Annotation>[] annotations, boolean annotatedByAll) {
        Field[] allFields = new Field[]{};
        while (clazz != null && ReflectionHelper.isAssignableFrom(clazz, boundingClasses, boundToAll) && ReflectionHelper.isAnnotationPresent(clazz, annotations, annotatedByAll)) {
            Field[] fields = clazz.getDeclaredFields();
            Field[] tempFields = new Field[allFields.length + fields.length];
            System.arraycopy(allFields, 0, tempFields, 0, allFields.length);
            System.arraycopy(fields, 0, tempFields, allFields.length, fields.length);
            allFields = tempFields;
            clazz = clazz.getSuperclass();
        }
        return allFields;
    }

    public static Method[] getAllMethods(Class<?> clazz, Class<?>[] boundingClasses, boolean boundToAll, Class<Annotation>[] annotations, boolean annotatedByAll) {
        Method[] allMethods = new Method[]{};
        while (clazz != null && ReflectionHelper.isAssignableFrom(clazz, boundingClasses, boundToAll) && ReflectionHelper.isAnnotationPresent(clazz, annotations, annotatedByAll)) {
            Method[] methods = clazz.isInterface() ? clazz.getMethods() : clazz.getDeclaredMethods();
            Method[] tempMethods = new Method[allMethods.length + methods.length];
            System.arraycopy(allMethods, 0, tempMethods, 0, allMethods.length);
            System.arraycopy(methods, 0, tempMethods, allMethods.length, methods.length);
            allMethods = tempMethods;
            clazz = clazz.getSuperclass();
        }
        return allMethods;
    }

    public static boolean isGetter(Method method) {
        return method.getReturnType() != Void.TYPE && !Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length == 0;
    }

    public static boolean isSetter(Method method) {
        return method.getReturnType() == Void.TYPE && !Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length == 1;
    }

    public static String getPathMethodName(Method method) {
        String name = method.getName();
        int length = name.length();
        if (name.startsWith("get") && length > 3 && Character.isUpperCase(name.charAt(3))) {
            name = name.substring(3);
        }
        if (name.startsWith("set") && length > 3 && Character.isUpperCase(name.charAt(3))) {
            name = name.substring(3);
        } else if (name.startsWith("is") && length > 2 && Character.isUpperCase(name.charAt(2)) && (method.getReturnType().equals(Boolean.class) || method.getReturnType().equals(Boolean.TYPE))) {
            name = name.substring(2);
        }
        return StringHelper.firstToLower((String)name);
    }

    public static String getPathGetterName(Method method) {
        if (ReflectionHelper.isGetter(method)) {
            return ReflectionHelper.getPathMethodName(method);
        }
        return null;
    }

    public static String getPathSetterName(Method method) {
        String name;
        if (ReflectionHelper.isSetter(method) && !(name = ReflectionHelper.getPathMethodName(method)).startsWith("set")) {
            return name;
        }
        return null;
    }

    public static Object getValueByPath(Object root, String path) {
        StringBuilder donePath = new StringBuilder();
        if (path != null) {
            boolean noNullRefs;
            boolean bl = noNullRefs = path.lastIndexOf(42) == path.length() - 1;
            if (noNullRefs) {
                if (path.length() > 1) {
                    path = path.substring(0, path.length() - 1);
                } else {
                    return root;
                }
            }
            StringTokenizer stok = new StringTokenizer(path, ".");
            while (stok.hasMoreTokens()) {
                Object value;
                if (root == null) {
                    if (noNullRefs) {
                        throw new TentackleRuntimeException("reference '" + donePath + "' is null");
                    }
                    return null;
                }
                Class<?> clazz = root.getClass();
                String element = stok.nextToken();
                if (element.endsWith("()")) {
                    element = element.substring(0, element.length() - 2);
                }
                if (donePath.length() > 0) {
                    donePath.append('.');
                }
                donePath.append(element);
                Method method = ReflectionHelper.getMethodForElement(clazz, element);
                if (method != null && ReflectionHelper.isGetter(method)) {
                    try {
                        try {
                            value = method.invoke(root, new Object[0]);
                        }
                        catch (IllegalAccessException ex) {
                            method.setAccessible(true);
                            value = method.invoke(root, new Object[0]);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        throw new TentackleRuntimeException("cannot retrieve '" + donePath + "' in " + root.getClass().getName() + " by method " + method.getName(), (Throwable)ex);
                    }
                } else {
                    Field field = ReflectionHelper.getFieldForElement(clazz, element);
                    if (field != null) {
                        try {
                            try {
                                value = field.get(root);
                            }
                            catch (IllegalAccessException ex) {
                                field.setAccessible(true);
                                value = field.get(root);
                            }
                        }
                        catch (IllegalAccessException | IllegalArgumentException ex) {
                            throw new TentackleRuntimeException("cannot retrieve '" + donePath + "' in " + root.getClass().getName() + " by field " + field.getName(), (Throwable)ex);
                        }
                    } else {
                        throw new TentackleRuntimeException("cannot find '" + element + "' in " + clazz.getName());
                    }
                }
                if (stok.hasMoreTokens()) {
                    if (value == null && noNullRefs) {
                        throw new TentackleRuntimeException("path '" + donePath + "' is null");
                    }
                    root = value;
                    continue;
                }
                return value;
            }
        } else {
            return root;
        }
        throw new TentackleRuntimeException("no such path '" + donePath + "'");
    }

    public static Object getStaticValueByPath(Class<?> clazz, String path) {
        if (path != null) {
            String element = path;
            int ndx = path.indexOf(46);
            if (ndx > 0) {
                element = path.substring(0, ndx);
                path = path.substring(ndx + 1);
            } else {
                path = null;
            }
            Method method = ReflectionHelper.getMethodForElement(clazz, element);
            if (method != null && Modifier.isStatic(method.getModifiers())) {
                try {
                    return ReflectionHelper.getValueByPath(method.invoke(null, new Object[0]), path);
                }
                catch (IllegalAccessException ex) {
                    try {
                        method.setAccessible(true);
                        return ReflectionHelper.getValueByPath(method.invoke(null, new Object[0]), path);
                    }
                    catch (IllegalAccessException | RuntimeException | InvocationTargetException ex2) {
                        throw new TentackleRuntimeException("cannot retrieve '" + path + "' in " + clazz.getName() + " by method " + method.getName(), (Throwable)ex2);
                    }
                }
            }
        }
        throw new TentackleRuntimeException("path is null");
    }

    public static boolean verifyPath(Class<?> clazz, String path) {
        StringBuilder donePath = new StringBuilder();
        if (path != null && path.length() > 0) {
            StringTokenizer stok = new StringTokenizer(path, ".");
            while (stok.hasMoreTokens() && clazz != null) {
                String element = stok.nextToken();
                if (donePath.length() == 0) {
                    donePath.append(element);
                } else {
                    donePath.append('.');
                    donePath.append(element);
                }
                Method method = ReflectionHelper.getMethodForElement(clazz, element);
                if (method != null) {
                    clazz = method.getReturnType();
                } else {
                    Field field = ReflectionHelper.getFieldForElement(clazz, element);
                    if (field != null) {
                        clazz = field.getType();
                    } else {
                        throw new TentackleRuntimeException("cannot find '" + element + "' in " + clazz.getName());
                    }
                }
                if (stok.hasMoreTokens()) {
                    if (clazz != null) continue;
                    throw new TentackleRuntimeException("path '" + donePath + "' is null");
                }
                return true;
            }
        } else {
            return true;
        }
        throw new TentackleRuntimeException("no such path '" + donePath + "'");
    }

    public static Method findDeclaredMethod(Class<?> clazz, Method method) {
        try {
            method = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException nme) {
            for (Class<?> ifClass : clazz.getInterfaces()) {
                Method m = ReflectionHelper.findDeclaredMethod(ifClass, method);
                if (m.equals(method)) continue;
                method = m;
                break;
            }
        }
        return method;
    }

    private static Method getMethodForElement(Class<?> clazz, String element) {
        Method method = null;
        String camelName = StringHelper.firstToUpper((String)element);
        try {
            method = clazz.getMethod(element, new Class[0]);
        }
        catch (NoSuchMethodException ex1) {
            try {
                method = clazz.getMethod("is" + camelName, new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                try {
                    method = clazz.getMethod("get" + camelName, new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return method;
    }

    private static Field getFieldForElement(Class<?> clazz, String element) {
        Field field = null;
        try {
            field = clazz.getField(element);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field;
    }

    private ReflectionHelper() {
    }

    static {
        PRIMITIVES.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES.put(Byte.TYPE, Byte.class);
        PRIMITIVES.put(Character.TYPE, Character.class);
        PRIMITIVES.put(Short.TYPE, Short.class);
        PRIMITIVES.put(Integer.TYPE, Integer.class);
        PRIMITIVES.put(Long.TYPE, Long.class);
        PRIMITIVES.put(Double.TYPE, Double.class);
        PRIMITIVES.put(Float.TYPE, Float.class);
        WRAPPERS = new HashMap();
        WRAPPERS.put(Boolean.class, Boolean.TYPE);
        WRAPPERS.put(Byte.class, Byte.TYPE);
        WRAPPERS.put(Character.class, Character.TYPE);
        WRAPPERS.put(Short.class, Short.TYPE);
        WRAPPERS.put(Integer.class, Integer.TYPE);
        WRAPPERS.put(Long.class, Long.TYPE);
        WRAPPERS.put(Double.class, Double.TYPE);
        WRAPPERS.put(Float.class, Float.TYPE);
    }
}

