/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.log.Logger;
import org.tentackle.reflect.EffectiveClassProvider;
import org.tentackle.reflect.MethodCache;

public abstract class ReflectiveVisitor {
    private static final Logger LOGGER = Logger.get(ReflectiveVisitor.class);
    private static final String METHOD_NAME = "visit";
    private static final MethodCache METHOD_CACHE = new MethodCache("methodcache[" + ReflectiveVisitor.class.getName() + "]");

    public void visit(Object visitedObject, Class<?>[] types, Object ... args) throws NoSuchMethodException {
        Class<?> visitedClass = EffectiveClassProvider.getEffectiveClass(visitedObject);
        Method method = this.findBestMethod(visitedClass, types);
        if (method == null) {
            throw new NoSuchMethodException("no visit method in " + this.getClass().getName() + " for " + visitedClass.getName());
        }
        try {
            LOGGER.fine(() -> "invoking " + method + "(" + StringHelper.objectArrayToString((Object[])args, (String)", ") + ")");
            method.invoke((Object)this, args);
        }
        catch (IllegalAccessException iae) {
            this.handleException(iae, method, args);
        }
        catch (InvocationTargetException ite) {
            Throwable thrbl = ite.getCause();
            if (thrbl instanceof RuntimeException) {
                throw (RuntimeException)thrbl;
            }
            this.handleException(ite.getCause(), method, args);
        }
    }

    protected Method findBestMethod(Class<?> visitedClass, Class<?>[] types) {
        Method method = null;
        for (Class<?> clazz = visitedClass; clazz != null && this.isImplementedClass(clazz) && (method = METHOD_CACHE.getMethod(this.getClass(), types)) == null; clazz = clazz.getSuperclass()) {
            try {
                types[0] = clazz;
                method = this.findVisitMethod(types);
                types[0] = visitedClass;
                METHOD_CACHE.addMethod(method, this.getClass(), types);
                break;
            }
            catch (NoSuchMethodException nme) {
                continue;
            }
        }
        return method;
    }

    protected Method findVisitMethod(Class<?>[] types) throws NoSuchMethodException {
        return this.getClass().getMethod(METHOD_NAME, types);
    }

    protected boolean isImplementedClass(Class<?> clazz) {
        return true;
    }

    protected void handleException(Throwable thrbl, Method method, Object ... args) {
        String message = "invocation of " + method + " failed for ";
        try {
            message = message + StringHelper.objectArrayToString((Object[])args, (String)", ");
        }
        catch (RuntimeException re) {
            message = message + "? -> " + re.getMessage();
        }
        throw new TentackleRuntimeException(message, thrbl);
    }
}

