/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.script;

import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.tentackle.log.Logger;
import org.tentackle.script.AbstractJSRScriptingLanguage;
import org.tentackle.script.AbstractScript;
import org.tentackle.script.ScriptRuntimeException;
import org.tentackle.script.ScriptVariable;

public class AbstractJSRScript
extends AbstractScript {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.get(AbstractJSRScript.class);
    private CompiledScript compiledScript;
    private volatile String scriptCode;
    private boolean executed;
    private Object result;

    public AbstractJSRScript(AbstractJSRScriptingLanguage language) {
        super(language, false);
    }

    @Override
    public AbstractJSRScriptingLanguage getLanguage() {
        return (AbstractJSRScriptingLanguage)super.getLanguage();
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript == null ? this.parse() : this.compiledScript;
    }

    @Override
    public boolean isParsed() {
        return this.compiledScript != null;
    }

    @Override
    public void clearParsed() {
        this.compiledScript = null;
    }

    @Override
    public CompiledScript parse() {
        try {
            this.scriptCode = this.getEffectiveCode();
            if (this.compiledScript == null) {
                LOGGER.fine("compiling script:\n{0}", this.scriptCode);
                this.compiledScript = ((Compilable)((Object)this.getLanguage().getEngine())).compile(this.scriptCode);
            } else {
                LOGGER.fine("re-using compiled script:\n{0}", this.scriptCode);
            }
            return this.compiledScript;
        }
        catch (ScriptException ex) {
            throw new ScriptRuntimeException("creating script failed: " + this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ScriptVariable ... variables) {
        block8: {
            this.executed = false;
            this.result = null;
            CompiledScript script = this.getCompiledScript();
            LOGGER.finer(() -> "execute: \n" + this.scriptCode + "\nwith args: " + ScriptVariable.variablesToString(variables));
            try {
                SimpleBindings bindings = new SimpleBindings();
                if (variables != null) {
                    for (ScriptVariable variable : variables) {
                        bindings.put(variable.getName(), variable.getValue());
                    }
                }
                if (this.isThreadSafe()) {
                    CompiledScript compiledScript = script;
                    synchronized (compiledScript) {
                        this.result = this.executeImpl(script, bindings);
                        break block8;
                    }
                }
                this.result = this.executeImpl(script, bindings);
            }
            catch (ScriptException ex) {
                throw new ScriptRuntimeException(ex);
            }
        }
        LOGGER.finer("returned: {0}", this.result);
        this.executed = true;
    }

    @Override
    public Object getResult() {
        if (!this.executed) {
            throw new ScriptRuntimeException("script not executed");
        }
        return this.result;
    }

    protected Object executeImpl(CompiledScript script, Bindings bindings) throws ScriptException {
        return this.compiledScript.eval(bindings);
    }
}

