/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.script;

import org.tentackle.common.StringHelper;
import org.tentackle.script.Script;
import org.tentackle.script.ScriptConverter;
import org.tentackle.script.ScriptingLanguage;

public abstract class AbstractScript
implements Script {
    private final ScriptingLanguage language;
    private final boolean cached;
    private String code;
    private ScriptConverter converter;
    private volatile boolean threadSafe;

    public AbstractScript(ScriptingLanguage language, boolean cached) {
        this.language = language;
        this.cached = cached;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("#!").append(this.getLanguage()).append("{ ");
        if (this.code != null) {
            String codeInfo = StringHelper.trim((String)this.code.replace('\n', ' '), (int)64);
            buf.append(codeInfo);
            if (codeInfo.length() < this.code.length()) {
                buf.append(" ...");
            }
        } else {
            buf.append("<null>");
        }
        buf.append(" }");
        return buf.toString();
    }

    @Override
    public ScriptingLanguage getLanguage() {
        return this.language;
    }

    @Override
    public void setThreadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    @Override
    public boolean isThreadSafe() {
        return this.threadSafe;
    }

    public boolean isCached() {
        return this.cached;
    }

    @Override
    public void setCode(String code) {
        if (code == null || code.isEmpty()) {
            throw new IllegalArgumentException("code must not be empty");
        }
        this.code = code;
        this.clearParsed();
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getEffectiveCode() {
        String effectiveCode = this.getCode();
        ScriptConverter cnvrtr = this.getConverter();
        if (cnvrtr != null) {
            effectiveCode = cnvrtr.convert(effectiveCode, this.getLanguage());
        }
        return effectiveCode;
    }

    @Override
    public void setConverter(ScriptConverter converter) {
        this.converter = converter;
    }

    @Override
    public ScriptConverter getConverter() {
        return this.converter;
    }
}

