/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.script;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.log.Logger;
import org.tentackle.script.Script;
import org.tentackle.script.ScriptFactory;
import org.tentackle.script.ScriptRuntimeException;
import org.tentackle.script.ScriptingLanguage;

@Service(value=ScriptFactory.class)
public class DefaultScriptFactory
implements ScriptFactory {
    private static final Logger LOGGER = Logger.get(DefaultScriptFactory.class);
    private Map<String, ScriptingLanguage> languages;
    private ScriptingLanguage defaultLanguage;
    private ScriptingLanguage loggedDefaultLanguage;

    @Override
    public synchronized void setDefaultLanguage(String abbreviation) {
        this.defaultLanguage = this.getLanguage(abbreviation);
    }

    @Override
    public synchronized ScriptingLanguage getDefaultLanguage() {
        if (this.loggedDefaultLanguage != this.defaultLanguage) {
            LOGGER.info("default scripting language is {0}", this.defaultLanguage);
            this.loggedDefaultLanguage = this.defaultLanguage;
        }
        return this.defaultLanguage;
    }

    @Override
    public synchronized Collection<ScriptingLanguage> getLanguages() {
        if (this.languages == null) {
            this.languages = new HashMap<String, ScriptingLanguage>();
            try {
                for (Class clazz : ServiceFactory.getServiceFinder().findServiceProviders(ScriptingLanguage.class)) {
                    ScriptingLanguage language = (ScriptingLanguage)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    for (String abbrv : language.getAbbreviations()) {
                        String abbrvLC = abbrv.toLowerCase();
                        this.languages.put(abbrvLC, language);
                        LOGGER.info("added scripting language {0} as {1}", language, abbrvLC);
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException nfe) {
                throw new ScriptRuntimeException("supported scripting languages could not be determined", nfe);
            }
        }
        return this.languages.values();
    }

    @Override
    public synchronized ScriptingLanguage getLanguage(String abbreviation) {
        ScriptingLanguage language;
        this.getLanguages();
        if (abbreviation != null && !abbreviation.isEmpty()) {
            abbreviation = abbreviation.toLowerCase();
            language = this.languages.get(abbreviation);
        } else {
            language = this.getDefaultLanguage();
        }
        if (language == null) {
            throw new ScriptRuntimeException((String)(abbreviation == null ? "default scripting language undefined" : "unsupported scripting language '" + abbreviation + "'"));
        }
        return language;
    }

    @Override
    public Script createScript(String abbreviation, String code, boolean cached, boolean threadSafe) {
        ScriptingLanguage language = this.getLanguage(abbreviation);
        Script script = language.createScript(cached);
        script.setCode(code);
        script.setThreadSafe(threadSafe);
        LOGGER.fine("created scripting object {0}", script);
        return script;
    }
}

