/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.script;

import org.tentackle.reflect.EffectiveClassProvider;

public class ScriptVariable {
    private static final long serialVersionUID = 7698497385959487231L;
    private final String name;
    private final Object value;

    public ScriptVariable(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName());
        buf.append("=");
        Object val = this.getValue();
        if (val == null) {
            buf.append("<null>");
        } else {
            buf.append("'");
            buf.append(val);
            buf.append("'(");
            buf.append(EffectiveClassProvider.getEffectiveClass(val).getName());
            buf.append(")");
        }
        return buf.toString();
    }

    public static String variablesToString(ScriptVariable ... variables) {
        StringBuilder args = new StringBuilder();
        if (variables != null) {
            boolean needComma = false;
            for (ScriptVariable variable : variables) {
                if (needComma) {
                    args.append(", ");
                } else {
                    needComma = true;
                }
                args.append(variable);
            }
        }
        return args.toString();
    }
}

