/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.task.Task;
import org.tentackle.task.TaskDispatcher;
import org.tentackle.task.TaskListener;

public abstract class AbstractPooledTaskDispatcher
implements TaskDispatcher {
    private String name;
    private boolean usingMutexLocking;
    private long sleepInterval;
    private final List<TaskListener> listeners;
    protected final Map<Task, TaskDispatcher> taskMap;
    protected final TaskListener taskListener;

    public AbstractPooledTaskDispatcher(String name, boolean useMutexLocking, long sleepInterval) {
        this.setName(name);
        this.setUsingMutexLocking(useMutexLocking);
        this.setSleepInterval(sleepInterval);
        this.taskMap = new ConcurrentHashMap<Task, TaskDispatcher>();
        this.listeners = new ArrayList<TaskListener>();
        this.taskListener = this.createTaskListener();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long getSleepInterval() {
        return this.sleepInterval;
    }

    @Override
    public void setSleepInterval(long sleepInterval) {
        this.sleepInterval = sleepInterval;
    }

    @Override
    public boolean isUsingMutexLocking() {
        return this.usingMutexLocking;
    }

    @Override
    public void setUsingMutexLocking(boolean usingMutexLocking) {
        this.usingMutexLocking = usingMutexLocking;
    }

    @Override
    public synchronized void addTaskListener(TaskListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeTaskListener(TaskListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int getQueueSize() {
        return this.taskMap.size();
    }

    @Override
    public boolean isQueueEmpty() {
        return this.taskMap.isEmpty();
    }

    @Override
    public synchronized boolean addTask(Task task) {
        if (this.taskMap.containsKey(task)) {
            return false;
        }
        TaskDispatcher dispatcher = this.getNextDispatcher();
        if (!dispatcher.addTask(task)) {
            throw new TentackleRuntimeException("dispatcher " + dispatcher + " out of sync");
        }
        this.taskMap.put(task, dispatcher);
        return true;
    }

    @Override
    public boolean isTaskPending(Task task) {
        TaskDispatcher dispatcher = this.getDispatcherForTask(task);
        return dispatcher != null && dispatcher.isTaskPending(task);
    }

    @Override
    public Collection<Task> getAllTasks() {
        return new ArrayList<Task>(this.taskMap.keySet());
    }

    @Override
    public boolean isInstanceOfTaskPending(Class<? extends Task> clazz) {
        for (Task task : this.taskMap.keySet()) {
            if (!clazz.isAssignableFrom(task.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void waitForTask(Task task) {
        TaskDispatcher dispatcher = this.getDispatcherForTask(task);
        if (dispatcher != null) {
            dispatcher.waitForTask(task);
        }
    }

    @Override
    public boolean addTaskAndWait(Task task) {
        if (this.addTask(task)) {
            this.waitForTask(task);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTask(Task task) {
        TaskDispatcher dispatcher = this.getDispatcherForTask(task);
        return dispatcher != null && dispatcher.removeTask(task);
    }

    protected TaskListener createTaskListener() {
        return new PooledTaskListener();
    }

    protected void fireStarted(Task task) {
        for (TaskListener listener : this.listeners) {
            listener.started(task);
        }
    }

    protected void fireCompleted(Task task) {
        for (TaskListener listener : this.listeners) {
            listener.completed(task);
        }
    }

    protected abstract TaskDispatcher getNextDispatcher();

    private TaskDispatcher getDispatcherForTask(Task task) {
        return this.taskMap.get(task);
    }

    public class PooledTaskListener
    implements TaskListener {
        @Override
        public void started(Task task) {
            AbstractPooledTaskDispatcher.this.fireStarted(task);
        }

        @Override
        public void completed(Task task) {
            AbstractPooledTaskDispatcher.this.taskMap.remove(task);
            AbstractPooledTaskDispatcher.this.fireCompleted(task);
        }
    }
}

