/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.tentackle.task.Task;
import org.tentackle.task.TaskDispatcher;
import org.tentackle.task.TaskListener;

public abstract class AbstractTask
implements Task {
    private static final long serialVersionUID = 6759258472780726126L;
    private Throwable cause;
    private Serializable result;
    private long started;
    private long completed;
    private long scheduled;
    private long repeat;
    private long id;
    private transient TaskDispatcher dispatcher;
    private transient List<TaskListener> listeners;

    @Override
    public int compareTo(Task o) {
        int rv = Long.compare(this.getScheduledEpochalTime(), o.getScheduledEpochalTime());
        if (rv == 0) {
            rv = Long.compare(this.getId(), o.getId());
        }
        return rv;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTask other = (AbstractTask)obj;
        return this.id == other.id;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + (int)(this.id ^ this.id >>> 32);
        return hash;
    }

    @Override
    public void setScheduledEpochalTime(long scheduled) {
        this.scheduled = scheduled;
    }

    @Override
    public long getScheduledEpochalTime() {
        return this.scheduled;
    }

    @Override
    public long getRepeatInterval() {
        return this.repeat;
    }

    @Override
    public void setRepeatInterval(long repeat) {
        if (repeat <= 0L) {
            throw new IllegalArgumentException("interval must be positive: " + repeat);
        }
        this.repeat = repeat;
        this.scheduled = System.currentTimeMillis() + repeat;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public TaskDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(TaskDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public Serializable getResult() {
        return this.result;
    }

    @Override
    public void setResult(Serializable result) {
        this.result = result;
    }

    @Override
    public long getCompleted() {
        return this.completed;
    }

    @Override
    public void setCompleted(long completed) {
        this.completed = completed;
        this.fireCompleted();
    }

    @Override
    public long getStarted() {
        return this.started;
    }

    @Override
    public void setStarted(long started) {
        this.started = started;
        this.fireStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaskListener(TaskListener listener) {
        AbstractTask abstractTask = this;
        synchronized (abstractTask) {
            this.getListeners().add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTaskListener(TaskListener listener) {
        AbstractTask abstractTask = this;
        synchronized (abstractTask) {
            this.getListeners().remove(listener);
        }
    }

    @Override
    public void fireStarted() {
        if (this.listeners != null) {
            for (TaskListener listener : this.listeners) {
                listener.started(this);
            }
        }
    }

    @Override
    public void fireCompleted() {
        if (this.listeners != null) {
            for (TaskListener listener : this.listeners) {
                listener.completed(this);
            }
        }
    }

    @Override
    public boolean isInterruptable() {
        return true;
    }

    private List<TaskListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<TaskListener>();
        }
        return this.listeners;
    }
}

