/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.task;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.tentackle.daemon.Supervisable;
import org.tentackle.log.Logger;
import org.tentackle.misc.NamedCounter;
import org.tentackle.task.DefaultTaskDispatcherLock;
import org.tentackle.task.Task;
import org.tentackle.task.TaskDispatcher;
import org.tentackle.task.TaskDispatcherLock;
import org.tentackle.task.TaskException;
import org.tentackle.task.TaskListener;

public class DefaultTaskDispatcher
extends Thread
implements TaskDispatcher,
Supervisable {
    public static final NamedCounter INSTANCE_COUNTER = new NamedCounter();
    private static final Logger LOGGER = Logger.get(DefaultTaskDispatcher.class);
    private static final DateFormat MILLIS_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final AtomicLong TASK_COUNTER = new AtomicLong();
    private boolean usingMutexLocking;
    private ReentrantReadWriteLock mutex;
    private long sleepInterval;
    private long deadInterval;
    private long shutdownIdleTimeout;
    private long lastActivity;
    private final ConcurrentSkipListSet<Task> queue;
    private final ConcurrentHashMap<Long, Task> idMap;
    private final List<TaskListener> listeners;
    private final ReentrantReadWriteLock interruptMutex;
    private int nonMutexLockCount;
    private Object unlockKey;
    private volatile long lastMillis;
    private volatile boolean stopRequested;
    private volatile boolean killed;
    private volatile boolean delayInterrupt;
    private volatile boolean wasInterrupted;
    private volatile long startTime;
    private volatile long terminationTime;
    private volatile RuntimeException terminationCause;

    public DefaultTaskDispatcher(String name, boolean usingMutexLocking, long sleepInterval, long deadInterval) {
        super(name + "(" + INSTANCE_COUNTER.next(name) + ")");
        this.setDaemon(true);
        this.setUsingMutexLocking(usingMutexLocking);
        this.setSleepInterval(sleepInterval);
        this.setDeadInterval(deadInterval);
        this.queue = new ConcurrentSkipListSet();
        this.listeners = new ArrayList<TaskListener>();
        this.idMap = new ConcurrentHashMap();
        this.interruptMutex = new ReentrantReadWriteLock();
    }

    public DefaultTaskDispatcher(String name) {
        this(name, false, 1000L, 10000L);
    }

    public boolean isTaskDispatcherThread() {
        return Thread.currentThread() == this;
    }

    @Override
    public void setShutdownIdleTimeout(long shutdownIdleTimeout) {
        this.shutdownIdleTimeout = shutdownIdleTimeout;
    }

    @Override
    public long getShutdownIdleTimeout() {
        return this.shutdownIdleTimeout;
    }

    @Override
    public long getSleepInterval() {
        return this.sleepInterval;
    }

    @Override
    public void setSleepInterval(long sleepInterval) {
        if (sleepInterval <= 0L) {
            throw new IllegalArgumentException(this + ": sleep interval must be > 0");
        }
        this.sleepInterval = sleepInterval;
        this.assertIntervalsInRange();
    }

    @Override
    public long getDeadInterval() {
        return this.deadInterval;
    }

    @Override
    public void setDeadInterval(long deadInterval) {
        if (deadInterval < 0L) {
            throw new IllegalArgumentException(this + ": dead interval must be >= 0");
        }
        this.deadInterval = deadInterval;
        this.assertIntervalsInRange();
    }

    @Override
    public synchronized boolean isUsingMutexLocking() {
        return this.usingMutexLocking;
    }

    @Override
    public synchronized void setUsingMutexLocking(boolean usingMutexLocking) {
        this.assertNotAlive();
        this.usingMutexLocking = usingMutexLocking;
        if (usingMutexLocking) {
            this.mutex = new ReentrantReadWriteLock();
        } else {
            this.mutex = null;
            this.nonMutexLockCount = 0;
        }
    }

    @Override
    public synchronized String toDiagnosticString() {
        StringBuilder buf = new StringBuilder(this.toString());
        buf.append("\n    class=");
        buf.append(this.getClass());
        buf.append(", useMutexLocking=");
        buf.append(this.isUsingMutexLocking());
        buf.append(", sleepInterval=");
        buf.append(this.getSleepInterval());
        buf.append(", deadInterval=");
        buf.append(this.getDeadInterval());
        buf.append("\n    lastMillis=");
        buf.append(MILLIS_FORMAT.format(new Date(this.lastMillis)));
        buf.append(", stopRequested=");
        buf.append(this.stopRequested);
        buf.append(", dead=");
        buf.append(this.isDead());
        buf.append(", killed=");
        buf.append(this.isKilled());
        if (this.unlockKey != null) {
            buf.append(", unlockKey='");
            buf.append(this.unlockKey);
            buf.append("'");
        }
        return buf.toString();
    }

    @Override
    public boolean isDead() {
        return this.deadInterval > 0L && this.lastMillis > 0L && System.currentTimeMillis() > this.lastMillis + this.deadInterval;
    }

    @Override
    public void setDead(boolean dead) {
        this.assertNotKilled();
        if (dead) {
            if (this.deadInterval <= 0L) {
                throw new TaskException("cannot mark dispatcher dead with deadInterval <= 0");
            }
            this.lastMillis = 1L;
        } else {
            this.lastMillis = System.currentTimeMillis();
        }
    }

    @Override
    public long startedAt() {
        return this.startTime;
    }

    @Override
    public long terminatedAt() {
        return this.terminationTime;
    }

    @Override
    public RuntimeException getTerminationCause() {
        return this.terminationCause;
    }

    @Override
    public void kill() {
        this.assertNotKilled();
        this.terminate();
        this.killed = true;
    }

    @Override
    public boolean isKilled() {
        return this.killed;
    }

    @Override
    public synchronized void addTaskListener(TaskListener listener) {
        this.assertNotKilled();
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeTaskListener(TaskListener listener) {
        this.assertNotKilled();
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addTask(Task task) {
        this.assertNotKilled();
        Task task2 = task;
        synchronized (task2) {
            if (task.getDispatcher() != null && task.getDispatcher() != this) {
                throw new TaskException("task " + task + " already belongs to dispatcher " + task.getDispatcher() + ", cannot be added to " + this);
            }
            if (task.getId() != 0L && this.queue.contains(task)) {
                LOGGER.fine("{0}: task {1} already in queue -- not added", this, task);
                return false;
            }
            task.setDispatcher(this);
            if (task.getId() == 0L) {
                task.setId(TASK_COUNTER.incrementAndGet());
            }
            this.queue.add(task);
            this.idMap.put(task.getId(), task);
            LOGGER.fine("{0}: task {1} added", this, task);
            this.safeInterrupt();
            return true;
        }
    }

    @Override
    public boolean isTaskPending(Task task) {
        this.assertNotKilled();
        return this.queue.contains(task);
    }

    @Override
    public Collection<Task> getAllTasks() {
        return new ArrayList<Task>(this.idMap.values());
    }

    @Override
    public Task getTask(long taskId) {
        this.assertNotKilled();
        return this.idMap.get(taskId);
    }

    @Override
    public boolean isInstanceOfTaskPending(Class<? extends Task> clazz) {
        for (Task task : this.idMap.values()) {
            if (!clazz.isAssignableFrom(task.getClass())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitForTask(Task task) {
        while (true) {
            try {
                while (true) {
                    Task task2 = task;
                    synchronized (task2) {
                        if (!this.isTaskPending(task)) return;
                        task.wait(this.sleepInterval);
                    }
                }
            }
            catch (InterruptedException ex) {
                LOGGER.warning("interrupted -> ignored");
                continue;
            }
            break;
        }
    }

    @Override
    public boolean addTaskAndWait(Task task) {
        if (this.addTask(task)) {
            this.waitForTask(task);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTask(Task task) {
        Task task2 = task;
        synchronized (task2) {
            this.assertNotKilled();
            boolean removed = this.queue.remove(task);
            if (removed) {
                this.idMap.remove(task.getId());
                task.setDispatcher(null);
            }
            return removed;
        }
    }

    @Override
    public int getQueueSize() {
        this.assertNotKilled();
        return this.queue.size();
    }

    @Override
    public boolean isQueueEmpty() {
        this.assertNotKilled();
        return this.queue.isEmpty();
    }

    @Override
    public void interrupt() {
        if (this.delayInterrupt) {
            this.wasInterrupted = true;
        } else {
            super.interrupt();
        }
    }

    @Override
    public void requestTermination() {
        this.assertNotKilled();
        this.stopRequested = true;
        this.interrupt();
    }

    @Override
    public boolean isTerminationRequested() {
        return this.stopRequested;
    }

    @Override
    public void terminate() {
        this.requestTermination();
        if (Thread.currentThread() != this) {
            while (true) {
                try {
                    this.join(this.deadInterval > 0L ? this.deadInterval : this.sleepInterval * 10L);
                }
                catch (InterruptedException e) {
                    LOGGER.warning("termination interrupted -> ignored");
                    continue;
                }
                break;
            }
            if (this.isAlive()) {
                LOGGER.severe(this + " does not terminate -> marking dispatcher killed!");
                this.killed = true;
            }
            this.cleanup();
        }
    }

    @Override
    public TaskDispatcherLock lock(Object key) {
        this.assertNotKilled();
        LOGGER.finer("{0}: lock requested for {1}", this, key);
        this.checkNullKey(key);
        Thread currentThread = Thread.currentThread();
        if (currentThread == this) {
            throw new TaskException(this + ": is not allowed to lock itself");
        }
        return this.lockImpl(key);
    }

    @Override
    public boolean unlock(Object key) {
        this.assertNotKilled();
        LOGGER.finer("{0}: unlock requested for {1}", this, key);
        this.checkNullKey(key);
        return this.unlockImpl(key);
    }

    protected void assertNotKilled() {
        if (this.isKilled()) {
            throw new TaskException("dispatcher " + this + " has already been killed");
        }
    }

    protected void fireStarted(Task task) {
        for (TaskListener listener : this.listeners) {
            try {
                listener.started(task);
            }
            catch (RuntimeException ex) {
                LOGGER.warning("invoking listener failed", ex);
            }
        }
    }

    protected void fireCompleted(Task task) {
        for (TaskListener listener : this.listeners) {
            try {
                listener.completed(task);
            }
            catch (RuntimeException ex) {
                LOGGER.warning("invoking listener failed", ex);
            }
        }
    }

    protected void lockInternal() {
        this.lockImpl(null);
    }

    protected void unlockInternal(long sleepMs) {
        this.unlockImpl(null);
        if (sleepMs > 0L && !this.wasInterrupted) {
            this.sleepForInterval(sleepMs);
        }
        this.wasInterrupted = false;
    }

    @Override
    public void run() {
        this.lastActivity = this.startTime = System.currentTimeMillis();
        LOGGER.info("{0} started", this);
        if (this.sleepInterval <= 0L) {
            throw new TaskException("sleep interval not configured");
        }
        this.assertIntervalsInRange();
        block6: while (true) {
            try {
                while (!this.stopRequested && !this.isKilled()) {
                    this.lockInternal();
                    this.lastMillis = System.currentTimeMillis();
                    Task task = this.nextTask();
                    if (this.stopRequested || this.isKilled()) break block6;
                    if (task == null) {
                        LOGGER.finer("{0}: queue is empty", this);
                        if (this.lastActivity != 0L && this.shutdownIdleTimeout > 0L && this.lastMillis - this.lastActivity > this.shutdownIdleTimeout) {
                            LOGGER.info("shutting down {0} due to idle timeout", this);
                            break block6;
                        }
                        this.unlockInternal(this.sleepInterval);
                        continue;
                    }
                    if (task.getScheduledEpochalTime() > this.lastMillis) {
                        long sleepMs = task.getScheduledEpochalTime() - this.lastMillis;
                        LOGGER.finer("{0}: next task {1} will be executed in {2}ms", this, task, sleepMs);
                        this.lastActivity = this.lastMillis;
                        this.unlockInternal(sleepMs);
                        continue;
                    }
                    try {
                        this.executeTask(task);
                        continue block6;
                    }
                    catch (RuntimeException ex) {
                        LOGGER.severe("executing task failed", ex);
                    }
                }
                break;
            }
            catch (RuntimeException rex) {
                LOGGER.severe("dispatcher failed", rex);
                this.terminationCause = rex;
                break;
            }
        }
        try {
            this.cleanup();
        }
        catch (RuntimeException ex) {
            LOGGER.warning("cleanup failed", ex);
        }
        this.terminationTime = System.currentTimeMillis();
        LOGGER.info("{0} {1}", this, this.isKilled() ? "killed" : "terminated");
    }

    protected Task nextTask() {
        try {
            return this.queue.first();
        }
        catch (NoSuchElementException nse) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask(Task task) {
        this.lastMillis = System.currentTimeMillis();
        this.lastActivity = 0L;
        task.setStarted(this.lastMillis);
        LOGGER.fine("{0}: task {1} started", this, task);
        this.fireStarted(task);
        Task task2 = task;
        synchronized (task2) {
            try {
                if (!task.isInterruptable()) {
                    this.delayInterrupt = true;
                }
                this.interruptMutex.writeLock().lock();
                try {
                    task.run();
                }
                catch (Throwable t) {
                    task.setCause(t);
                    LOGGER.severe("task '" + task + "', ID=" + task.getId() + " terminated abnormally", t);
                }
                finally {
                    this.delayInterrupt = false;
                    this.interruptMutex.writeLock().unlock();
                }
                this.lastMillis = System.currentTimeMillis();
                try {
                    task.setCompleted(this.lastMillis);
                }
                catch (RuntimeException ex) {
                    LOGGER.severe("cannot set task '" + task + "', ID=" + task.getId() + " completed", ex);
                }
                this.lastActivity = this.lastMillis;
            }
            finally {
                task.notifyAll();
            }
            this.unlockInternal(0L);
            this.queue.remove(task);
            long repeat = task.getRepeatInterval();
            if (repeat > 0L && task.getDispatcher() == this) {
                task.setScheduledEpochalTime(this.lastMillis + repeat);
                this.queue.add(task);
            } else {
                this.idMap.remove(task.getId());
            }
        }
        LOGGER.fine("{0}: task {1} completed", this, task);
        this.fireCompleted(task);
    }

    protected void cleanup() {
    }

    protected void sleepForInterval(long sleepMs) {
        try {
            DefaultTaskDispatcher.sleep(sleepMs);
        }
        catch (InterruptedException ex) {
            LOGGER.fine("interrupted!");
        }
    }

    protected TaskDispatcherLock createLock(Object key) {
        return new DefaultTaskDispatcherLock(this, key);
    }

    protected void assertAlive() {
        if (this.lastMillis > 0L && !this.isAlive()) {
            throw new TaskException("dispatcher " + this + " has already been terminated");
        }
    }

    protected void assertNotAlive() {
        if (this.isAlive()) {
            throw new TaskException("dispatcher " + this + " is already running");
        }
    }

    protected void assertIntervalsInRange() {
        if (this.deadInterval > 0L && this.sleepInterval > 0L && this.deadInterval <= this.sleepInterval) {
            throw new IllegalArgumentException(this + ": dead detection interval must be > sleep interval");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskDispatcherLock lockImpl(Object key) {
        int lockingLevel;
        while (true) {
            if (this.usingMutexLocking) {
                while (true) {
                    this.assertAlive();
                    this.assertNotKilled();
                    try {
                        this.mutex.writeLock().lockInterruptibly();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    catch (RuntimeException re) {
                        throw new TaskException("mutex lock failed", re);
                    }
                    break;
                }
                try {
                    lockingLevel = this.mutex.getWriteHoldCount();
                    if (!this.checkLockKey(key, lockingLevel)) continue;
                    break;
                }
                catch (RuntimeException re) {
                    this.mutex.writeLock().unlock();
                    if (re instanceof TaskException) {
                        throw re;
                    }
                    throw new TaskException("obtaining lock failed", re);
                }
            }
            DefaultTaskDispatcher defaultTaskDispatcher = this;
            synchronized (defaultTaskDispatcher) {
                this.assertAlive();
                this.assertNotKilled();
                lockingLevel = ++this.nonMutexLockCount;
                try {
                    if (this.checkLockKey(key, lockingLevel)) {
                        break;
                    }
                }
                catch (RuntimeException re) {
                    --this.nonMutexLockCount;
                    if (re instanceof TaskException) {
                        throw re;
                    }
                    throw new TaskException("counter lock failed", re);
                }
            }
        }
        return lockingLevel == 1 ? this.createLock(key) : null;
    }

    private synchronized boolean checkLockKey(Object key, int lockingLevel) {
        this.assertAlive();
        this.assertNotKilled();
        if (lockingLevel == 1) {
            this.unlockKey = key;
            LOGGER.fine("{0}: lock succeeded for {1}", this, this.unlockKey);
        } else if (key != this.unlockKey) {
            if (this.usingMutexLocking) {
                this.unlockImpl(this.unlockKey);
                throw new TaskException(this + ": same thread '" + Thread.currentThread() + "' requested nested mutex lock with non-matching key! Expected=" + (this.unlockKey == null ? "<null>" : this.unlockKey.toString()) + ", got=" + (key == null ? "<null>" : key.toString()));
            }
            --this.nonMutexLockCount;
            try {
                LOGGER.finer("{0}: waiting for unlock of {1} ...", this, this.unlockKey);
                this.wait(this.sleepInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unlockImpl(Object key) {
        int lockingLevel;
        if (this.usingMutexLocking) {
            this.checkUnlockKey(key);
            try {
                this.mutex.writeLock().unlock();
            }
            catch (RuntimeException re) {
                throw new TaskException("unlock failed", re);
            }
            lockingLevel = this.mutex.getWriteHoldCount();
        } else {
            DefaultTaskDispatcher defaultTaskDispatcher = this;
            synchronized (defaultTaskDispatcher) {
                try {
                    this.checkUnlockKey(key);
                    if (this.nonMutexLockCount <= 0) {
                        throw new TaskException("dispatcher is not locked at all");
                    }
                    --this.nonMutexLockCount;
                    lockingLevel = this.nonMutexLockCount;
                }
                finally {
                    this.notifyAll();
                }
            }
        }
        return lockingLevel == 0;
    }

    private void safeInterrupt() {
        if (this.interruptMutex.readLock().tryLock()) {
            try {
                super.interrupt();
            }
            finally {
                this.interruptMutex.readLock().unlock();
            }
        }
    }

    private void checkNullKey(Object key) {
        if (!this.usingMutexLocking && key == null) {
            LOGGER.warning(this + ": counter-based locking and null key is potentially unsafe! Please use a key!", (Throwable)((Object)new TaskException(">>> invoked from >>>")));
        }
    }

    private void checkUnlockKey(Object key) {
        if (key != this.unlockKey) {
            throw new TaskException(this + ": non-matching unlock key! Expected=" + (this.unlockKey == null ? "<null>" : this.unlockKey.toString()) + ", got=" + (key == null ? "<null>" : key.toString()));
        }
    }
}

