/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.task;

import org.tentackle.daemon.DaemonSupervisor;
import org.tentackle.log.Logger;
import org.tentackle.task.AbstractPooledTaskDispatcher;
import org.tentackle.task.DefaultTaskDispatcher;
import org.tentackle.task.Task;
import org.tentackle.task.TaskDispatcher;
import org.tentackle.task.TaskDispatcherLock;

public class PooledTaskDispatcher
extends AbstractPooledTaskDispatcher {
    private static final Logger LOGGER = Logger.get(PooledTaskDispatcher.class);
    private final boolean supervised;
    private long deadInterval;
    private final TaskDispatcher[] dispatchers;
    private final DaemonSupervisor supervisor;
    private int dispatcherIndex;
    private volatile boolean alive;
    private volatile boolean terminationRequested;

    public PooledTaskDispatcher(int poolSize, String name, boolean useMutexLocking, long sleepInterval, boolean supervised, long deadInterval) {
        super(name, useMutexLocking, sleepInterval);
        this.supervised = supervised;
        this.deadInterval = deadInterval;
        if (poolSize < 2) {
            throw new IllegalArgumentException("poolsize must be > 1");
        }
        this.dispatchers = new TaskDispatcher[poolSize];
        this.dispatcherIndex = poolSize - 1;
        if (supervised) {
            this.supervisor = this.createSupervisor();
            for (int i = 0; i < poolSize; ++i) {
                this.dispatchers[i] = null;
            }
        } else {
            this.supervisor = null;
            for (int i = 0; i < poolSize; ++i) {
                this.dispatchers[i] = this.createDispatcher(i);
                this.dispatchers[i].addTaskListener(this.taskListener);
            }
        }
    }

    public PooledTaskDispatcher(int poolSize, String name, boolean useMutexLocking, long sleepInterval) {
        this(poolSize, name, useMutexLocking, sleepInterval, false, 0L);
    }

    @Override
    public String toDiagnosticString() {
        StringBuilder buf = new StringBuilder();
        for (TaskDispatcher dispatcher : this.dispatchers) {
            if (dispatcher == null) continue;
            buf.append(dispatcher.toDiagnosticString());
            buf.append('\n');
        }
        return buf.toString();
    }

    public int getPoolSize() {
        return this.dispatchers.length;
    }

    public boolean isSupervised() {
        return this.supervised;
    }

    @Override
    public long getDeadInterval() {
        return this.deadInterval;
    }

    @Override
    public void setDeadInterval(long deadInterval) {
        this.deadInterval = deadInterval;
    }

    @Override
    public void setShutdownIdleTimeout(long shutdownIdleTimeout) {
        if (shutdownIdleTimeout != 0L) {
            throw new UnsupportedOperationException("pooled dispatcher does not support shutdown idle timeout");
        }
    }

    @Override
    public long getShutdownIdleTimeout() {
        return 0L;
    }

    public TaskDispatcher[] getDispatchers() {
        return this.dispatchers;
    }

    protected TaskDispatcher createDispatcher(int index) {
        return new DefaultTaskDispatcher(this.getName() + "-" + index, this.isUsingMutexLocking(), this.getSleepInterval(), this.isSupervised() ? this.getDeadInterval() : 0L);
    }

    protected DaemonSupervisor createSupervisor() {
        return new DaemonSupervisor("Supervisor for " + this.getName(), this.getDeadInterval(), 0, this.dispatchers.length){
            private int dsptchrIndex;

            @Override
            public Thread createDaemon(int index) {
                TaskDispatcher dispatcher = PooledTaskDispatcher.this.createDispatcher(index);
                dispatcher.addTaskListener(PooledTaskDispatcher.this.taskListener);
                this.dsptchrIndex = index;
                PooledTaskDispatcher.this.dispatchers[index] = dispatcher;
                return (Thread)((Object)dispatcher);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cleanupDaemon(Thread daemon) {
                super.cleanupDaemon(daemon);
                PooledTaskDispatcher pooledTaskDispatcher = PooledTaskDispatcher.this;
                synchronized (pooledTaskDispatcher) {
                    PooledTaskDispatcher.this.dispatchers[this.dsptchrIndex].removeTaskListener(PooledTaskDispatcher.this.taskListener);
                    PooledTaskDispatcher.this.dispatchers[this.dsptchrIndex] = null;
                }
            }
        };
    }

    @Override
    public void start() {
        if (this.isSupervised()) {
            this.supervisor.start();
        } else {
            for (TaskDispatcher dispatcher : this.dispatchers) {
                dispatcher.start();
            }
            this.alive = true;
        }
    }

    @Override
    public boolean isAlive() {
        if (this.isSupervised()) {
            return this.supervisor.isAlive();
        }
        return this.alive;
    }

    @Override
    public void terminate() {
        if (this.isSupervised()) {
            this.supervisor.terminate();
        } else {
            for (TaskDispatcher dispatcher : this.dispatchers) {
                dispatcher.terminate();
            }
            this.alive = false;
        }
    }

    @Override
    public void requestTermination() {
        this.terminationRequested = true;
        if (this.isSupervised()) {
            this.supervisor.requestTermination();
        } else {
            for (TaskDispatcher dispatcher : this.dispatchers) {
                dispatcher.requestTermination();
            }
        }
    }

    @Override
    public boolean isTerminationRequested() {
        return this.terminationRequested;
    }

    @Override
    public TaskDispatcherLock lock(Object key) {
        return this.getDispatcherForKey(key).lock(key);
    }

    @Override
    public boolean unlock(Object key) {
        return this.getDispatcherForKey(key).unlock(key);
    }

    @Override
    public Task getTask(long taskId) {
        for (TaskDispatcher dispatcher : this.dispatchers) {
            Task task;
            if (dispatcher.isAlive() && (task = dispatcher.getTask(taskId)) != null) {
                return task;
            }
            dispatcher.start();
        }
        return null;
    }

    @Override
    protected TaskDispatcher getNextDispatcher() {
        while (true) {
            int loopCount = 0;
            while (loopCount < 2) {
                TaskDispatcher dispatcher;
                ++this.dispatcherIndex;
                if (this.dispatcherIndex >= this.dispatchers.length) {
                    this.dispatcherIndex = 0;
                    ++loopCount;
                }
                if ((dispatcher = this.dispatchers[this.dispatcherIndex]) == null) continue;
                return dispatcher;
            }
            LOGGER.info("all dispatchers are dead -> waiting for {0} ms ...", this.getSleepInterval());
            try {
                Thread.sleep(this.getSleepInterval());
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskDispatcher getDispatcherForKey(Object key) {
        int index;
        int n = index = key == null ? 0 : key.hashCode() % this.dispatchers.length;
        if (this.isSupervised()) {
            while (true) {
                PooledTaskDispatcher pooledTaskDispatcher = this;
                synchronized (pooledTaskDispatcher) {
                    TaskDispatcher dispatcher = this.dispatchers[index];
                    if (dispatcher != null && dispatcher.isAlive()) {
                        return dispatcher;
                    }
                }
                LOGGER.info("dispatcher[{0}] is not alive -> waiting for {1} ms ...", index, this.getSleepInterval());
                try {
                    Thread.sleep(this.getSleepInterval());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.dispatchers[index];
    }
}

