/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.validate;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.StringHelper;
import org.tentackle.validate.ValidationRuntimeException;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationScopeFactory;
import org.tentackle.validate.ValidationScopeService;
import org.tentackle.validate.scope.AllScope;
import org.tentackle.validate.scope.ChangeableScope;
import org.tentackle.validate.scope.InteractiveScope;
import org.tentackle.validate.scope.MandatoryScope;
import org.tentackle.validate.scope.PersistenceScope;

@Service(value=ValidationScopeFactory.class)
public class DefaultValidationScopeFactory
implements ValidationScopeFactory {
    private final Map<String, Class<? extends ValidationScope>> scopesByName = new HashMap<String, Class<? extends ValidationScope>>();
    private final Map<Class<? extends ValidationScope>, ValidationScope> scopesByIface = new HashMap<Class<? extends ValidationScope>, ValidationScope>();
    private AllScope allScope;
    private ChangeableScope changeableScope;
    private InteractiveScope interactiveScope;
    private MandatoryScope mandatoryScope;
    private PersistenceScope persistenceScope;

    public DefaultValidationScopeFactory() {
        try {
            Map scopeMap = ServiceFactory.getServiceFinder().createNameMap(ValidationScopeService.class.getName());
            for (Map.Entry entry : scopeMap.entrySet()) {
                Class<?> scopeImplementation;
                Class<?> scopeInterface = Class.forName((String)entry.getKey());
                if (!scopeInterface.isAssignableFrom(scopeImplementation = Class.forName((String)entry.getValue()))) {
                    throw new ValidationRuntimeException("scope implementation " + scopeImplementation.getName() + " does not implement " + scopeInterface.getName());
                }
                ValidationScope scope = (ValidationScope)scopeImplementation.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (scope.getClass().getInterfaces()[0] != scopeInterface) {
                    throw new ValidationRuntimeException("scope interface of " + scopeImplementation.getName() + " is not a " + scopeInterface.getName());
                }
                String name = scope.getName();
                if (!StringHelper.isValidJavaIdentifier((String)name)) {
                    throw new ValidationRuntimeException("invalid name '" + name + "' in " + scopeImplementation.getName());
                }
                Class<?> oldValidationScope = this.scopesByName.put(name, scopeInterface);
                if (oldValidationScope != null) {
                    throw new ValidationRuntimeException("scope name '" + name + "' of " + scopeImplementation.getName() + " already used by " + oldValidationScope.getName());
                }
                this.scopesByIface.put(scopeInterface, scope);
                if (scope instanceof AllScope) {
                    this.allScope = (AllScope)scope;
                    continue;
                }
                if (scope instanceof ChangeableScope) {
                    this.changeableScope = (ChangeableScope)scope;
                    continue;
                }
                if (scope instanceof InteractiveScope) {
                    this.interactiveScope = (InteractiveScope)scope;
                    continue;
                }
                if (scope instanceof MandatoryScope) {
                    this.mandatoryScope = (MandatoryScope)scope;
                    continue;
                }
                if (!(scope instanceof PersistenceScope)) continue;
                this.persistenceScope = (PersistenceScope)scope;
            }
            if (this.allScope == null) {
                throw new ValidationRuntimeException("no AllScope configured");
            }
            if (this.changeableScope == null) {
                throw new ValidationRuntimeException("no ChangeableScope configured");
            }
            if (this.interactiveScope == null) {
                throw new ValidationRuntimeException("no InteractiveScope configured");
            }
            if (this.mandatoryScope == null) {
                throw new ValidationRuntimeException("no MandatoryScope configured");
            }
            if (this.persistenceScope == null) {
                throw new ValidationRuntimeException("no PersistenceScope configured");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | ValidationRuntimeException nfe) {
            throw new ValidationRuntimeException("supported scopes could not be determined", nfe);
        }
    }

    @Override
    public Collection<Class<? extends ValidationScope>> getValidationScopes() {
        return this.scopesByName.values();
    }

    @Override
    public Class<? extends ValidationScope> getValidationScope(String name) {
        return this.scopesByName.get(name);
    }

    @Override
    public <T extends ValidationScope> T getValidationScope(Class<T> iFace) {
        return (T)this.scopesByIface.get(iFace);
    }

    @Override
    public AllScope getAllScope() {
        return this.allScope;
    }

    @Override
    public ChangeableScope getChangeableScope() {
        return this.changeableScope;
    }

    @Override
    public InteractiveScope getInteractiveScope() {
        return this.interactiveScope;
    }

    @Override
    public MandatoryScope getMandatoryScope() {
        return this.mandatoryScope;
    }

    @Override
    public PersistenceScope getPersistenceScope() {
        return this.persistenceScope;
    }
}

