/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.validate;

import java.util.function.Supplier;
import org.tentackle.validate.ValidationScope;

public class ValidationContext {
    private final String validationPath;
    private final Class<?> type;
    private final Object object;
    private final Supplier<?> objectSupplier;
    private final Object parentObject;
    private final ValidationScope effectiveScope;

    public ValidationContext(String validationPath, Class<?> type, Object object, Object parentObject, ValidationScope effectiveScope) {
        this.validationPath = validationPath;
        this.type = type;
        this.object = object;
        this.objectSupplier = null;
        this.parentObject = parentObject;
        this.effectiveScope = effectiveScope;
    }

    public ValidationContext(String validationPath, Class<?> type, Supplier<?> objectSupplier, Object parentObject, ValidationScope effectiveScope) {
        this.validationPath = validationPath;
        this.type = type;
        this.object = null;
        this.objectSupplier = objectSupplier;
        this.parentObject = parentObject;
        this.effectiveScope = effectiveScope;
    }

    public String getValidationPath() {
        return this.validationPath;
    }

    public Object getObject() {
        return this.objectSupplier == null ? this.object : this.objectSupplier.get();
    }

    public Class<?> getType() {
        return this.type;
    }

    public ValidationScope getEffectiveScope() {
        return this.effectiveScope;
    }

    public Object getParentObject() {
        return this.parentObject;
    }

    public String toString() {
        return this.validationPath;
    }
}

