/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.validate;

import java.util.List;
import org.tentackle.log.Loggable;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationUtilities;

public class ValidationFailedException
extends RuntimeException
implements Loggable {
    private static final long serialVersionUID = 922168908361481367L;
    private final List<ValidationResult> results;
    private transient String resultsMessage;

    public ValidationFailedException() {
        this.results = null;
    }

    public ValidationFailedException(List<ValidationResult> results) {
        super(ValidationUtilities.getInstance().resultsToMessage(results));
        this.results = results;
    }

    public ValidationFailedException(String message) {
        super(message);
        this.results = null;
    }

    public ValidationFailedException(String message, List<ValidationResult> results) {
        super(message);
        this.results = results;
    }

    public ValidationFailedException(Throwable cause, List<ValidationResult> results) {
        super(cause);
        this.results = results;
    }

    public ValidationFailedException(String message, Throwable cause, List<ValidationResult> results) {
        super(message, cause);
        this.results = results;
    }

    public List<ValidationResult> getResults() {
        return this.results;
    }

    public String resultsAsMessage() {
        if (this.resultsMessage == null) {
            this.resultsMessage = ValidationUtilities.getInstance().resultsToMessage(this.results);
        }
        return this.resultsMessage;
    }

    @Override
    public boolean withStacktrace() {
        return false;
    }
}

