/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.validate;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.tentackle.bind.Binder;
import org.tentackle.common.LocaleProvider;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.log.Logger;
import org.tentackle.reflect.EffectiveClassProvider;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.validate.RepeatableValidation;
import org.tentackle.validate.Validateable;
import org.tentackle.validate.Validation;
import org.tentackle.validate.ValidationContext;
import org.tentackle.validate.ValidationMapper;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationRuntimeException;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationUtilitiesHolder;
import org.tentackle.validate.Validator;
import org.tentackle.validate.ValidatorCache;
import org.tentackle.validate.validator.FailedValidationResult;

@Service(value=ValidationUtilities.class)
public class ValidationUtilities {
    private static final Logger LOGGER = Logger.get(ValidationUtilities.class);
    private ClassLoader validationBundleClassLoader;
    private Logger.Level testLogLevel;

    public static ValidationUtilities getInstance() {
        return ValidationUtilitiesHolder.INSTANCE;
    }

    public void configureTestMode(Logger.Level testLogLevel) {
        this.testLogLevel = testLogLevel;
    }

    public ClassLoader getValidationBundleClassLoader() {
        return this.validationBundleClassLoader == null ? this.getClass().getClassLoader() : this.validationBundleClassLoader;
    }

    public void setValidationBundleClassLoader(ClassLoader validationBundleClassLoader) {
        this.validationBundleClassLoader = validationBundleClassLoader;
    }

    public String getDefaultValidationPath(Object object) {
        Class<?> clazz = EffectiveClassProvider.getEffectiveClass(object);
        return clazz == null ? "null" : StringHelper.firstToLower((String)ReflectionHelper.getClassBaseName(clazz));
    }

    public ValidationResult createFailedValidationResult(Validator validator, ValidationContext validationContext, String message) {
        return new FailedValidationResult(validator, validationContext, message);
    }

    public List<ValidationResult> validate(Validateable object, String validationPath, ValidationScope scope) {
        Class<?> clazz = EffectiveClassProvider.getEffectiveClass(object);
        List<Validator> validators = ValidatorCache.getInstance().getFieldValidators(clazz);
        List<ValidationResult> results = this.validateFields(validators, scope, validationPath, object);
        validators = ValidatorCache.getInstance().getObjectValidators(clazz);
        results.addAll(this.validateObject(validators, scope, validationPath, object, object, object.getClass()));
        return results;
    }

    public List<ValidationResult> validateCollection(Collection<? extends Validateable> collection, String validationPath, ValidationScope scope) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (collection != null) {
            int ndx = 0;
            for (Validateable validateable : collection) {
                if (validateable == null) continue;
                results.addAll(validateable.validate(validationPath + "[" + ndx++ + "]", scope));
            }
        }
        return results;
    }

    public List<Validator> getFieldValidators(Class<?> clazz, ValidationScope scope) {
        HashMap<ValidatorKey, Validator> validatorMap = new HashMap<ValidatorKey, Validator>();
        this.addFieldValidatorsToMap(validatorMap, clazz, scope);
        ArrayList<Validator> validators = new ArrayList<Validator>(validatorMap.values());
        this.sortValidatorsByPriority(validators);
        return validators;
    }

    protected void addFieldValidatorsToMap(Map<ValidatorKey, Validator> validatorMap, Class<?> clazz, ValidationScope scope) {
        for (Field field : ReflectionHelper.getAllFields(clazz, null, true, null, true)) {
            for (Validator validator : this.getElementValidators(field, scope)) {
                LOGGER.fine("field validator @{0} found for {1}:{2}", validator.getClass().getName(), clazz.getName(), field.getName());
                validatorMap.put(new ValidatorKey(validator), validator);
            }
        }
        for (AccessibleObject accessibleObject : ReflectionHelper.getAllMethods(clazz, null, true, null, true)) {
            if (((Method)accessibleObject).isBridge() || !ReflectionHelper.isGetter((Method)accessibleObject)) continue;
            for (Validator validator : this.getElementValidators(accessibleObject, scope)) {
                LOGGER.fine("method validator @{0} found for {1}:{2}", validator.getClass().getName(), clazz.getName(), ((Method)accessibleObject).getName());
                validatorMap.put(new ValidatorKey(validator), validator);
            }
        }
    }

    public List<Validator> getFieldValidators(Field field, Method method, ValidationScope scope) {
        HashMap<ValidatorKey, Validator> validatorMap = new HashMap<ValidatorKey, Validator>();
        this.addFieldValidatorsToMap(validatorMap, field, method, scope);
        ArrayList<Validator> validators = new ArrayList<Validator>(validatorMap.values());
        this.sortValidatorsByPriority(validators);
        return validators;
    }

    protected void addFieldValidatorsToMap(Map<ValidatorKey, Validator> validatorMap, Field field, Method method, ValidationScope scope) {
        boolean fineLoggable = LOGGER.isFineLoggable();
        if (field != null) {
            for (Validator validator : this.getElementValidators(field, scope)) {
                if (fineLoggable) {
                    LOGGER.fine("field validator @{0} found for {1}:{2}", validator.getClass().getName(), field.getDeclaringClass().getName(), field.getName());
                }
                validatorMap.put(new ValidatorKey(validator), validator);
            }
        }
        if (method != null && ReflectionHelper.isGetter(method)) {
            for (Validator validator : this.getElementValidators(method, scope)) {
                if (fineLoggable) {
                    LOGGER.fine("method validator @{0} found for {1}:{2}", validator.getClass().getName(), method.getDeclaringClass().getName(), method.getName());
                }
                validatorMap.put(new ValidatorKey(validator), validator);
            }
        }
    }

    public List<Validator> getObjectValidators(Class<?> clazz, ValidationScope scope) {
        ArrayList<Validator> validators = new ArrayList<Validator>();
        for (Annotation annotation : clazz.getAnnotations()) {
            this.extractValidators(annotation, clazz, validators, scope);
        }
        this.sortValidatorsByPriority(validators);
        return validators;
    }

    public List<ValidationResult> validateFields(List<Validator> validators, ValidationScope effectiveScope, String validationPath, Object parentObject) {
        if (validationPath == null) {
            validationPath = this.getDefaultValidationPath(parentObject);
        }
        ArrayList<ValidationResult> allResults = new ArrayList<ValidationResult>();
        boolean inTest = this.testLogLevel != null;
        for (Validator validator : validators) {
            List<? extends ValidationResult> results;
            Supplier<Object> objectSupplier = null;
            Class<?> type = null;
            AnnotatedElement element = validator.getAnnotatedElement();
            if (element instanceof Field) {
                Field field = (Field)element;
                type = field.getType();
                objectSupplier = parentObject == null ? null : () -> {
                    try {
                        return field.get(parentObject);
                    }
                    catch (IllegalAccessException ex1) {
                        field.setAccessible(true);
                        try {
                            return field.get(parentObject);
                        }
                        catch (IllegalAccessException ex2) {
                            throw new ValidationRuntimeException("cannot access field " + field, ex2);
                        }
                    }
                };
            } else if (element instanceof Method) {
                Method method = (Method)element;
                type = method.getReturnType();
                objectSupplier = parentObject == null ? null : () -> {
                    try {
                        return method.invoke(parentObject, new Object[0]);
                    }
                    catch (IllegalAccessException ex) {
                        try {
                            method.setAccessible(true);
                            return method.invoke(parentObject, new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex2) {
                            throw new ValidationRuntimeException("cannot invoke method " + method, ex2);
                        }
                    }
                };
            }
            ValidationContext validationContext = new ValidationContext(validationPath + "." + validator.getValidatedElementName(), type, objectSupplier, parentObject, effectiveScope);
            if (inTest) {
                this.logTest(validator, validationContext);
            }
            if ((!validator.isConditionValid(validationContext) || effectiveScope != null && !effectiveScope.appliesTo(validator.getConfiguredScopes(validationContext))) && !inTest || (results = validator.validate(validationContext)) == null || results.isEmpty()) continue;
            allResults.addAll(results);
        }
        return allResults;
    }

    public List<ValidationResult> validateObject(List<Validator> validators, ValidationScope effectiveScope, String validationPath, Object parentObject, Object object, Class<?> type) {
        ArrayList<ValidationResult> allResults = new ArrayList<ValidationResult>();
        if (!validators.isEmpty()) {
            if (validationPath == null) {
                validationPath = this.getDefaultValidationPath(object);
            }
            ValidationContext validationContext = new ValidationContext(validationPath, type, object, parentObject, effectiveScope);
            boolean inTest = this.testLogLevel != null;
            for (Validator validator : validators) {
                if (inTest) {
                    this.logTest(validator, validationContext);
                }
                if ((!validator.isConditionValid(validationContext) || effectiveScope != null && !effectiveScope.appliesTo(validator.getConfiguredScopes(validationContext))) && !inTest) continue;
                try {
                    List<? extends ValidationResult> results = validator.validate(validationContext);
                    if (results == null || results.isEmpty()) continue;
                    allResults.addAll(results);
                }
                catch (RuntimeException ex) {
                    LOGGER.severe("validator '" + validator + "' failed", ex);
                    throw ex;
                }
            }
        }
        return allResults;
    }

    public boolean hasFailed(List<ValidationResult> results) {
        for (ValidationResult result : results) {
            if (!result.hasFailed()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMessage(List<ValidationResult> results) {
        for (ValidationResult result : results) {
            if (!result.hasMessage()) continue;
            return true;
        }
        return false;
    }

    public String resultsToString(List<ValidationResult> results) {
        StringBuilder buf = new StringBuilder();
        if (results != null) {
            for (ValidationResult result : results) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append(result.toString());
            }
        }
        return buf.toString();
    }

    public String resultsToMessage(List<ValidationResult> results) {
        StringBuilder buf = new StringBuilder();
        if (results != null) {
            for (ValidationResult result : results) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append(result.getMessage());
            }
        }
        return buf.toString();
    }

    public MapResult mapValidationPath(TreeSet<ValidationMapper> mappers, Binder binder, String bindingPath) {
        Binder currentBinder = binder;
        Object currentPath = bindingPath;
        if (mappers != null) {
            ValidationMapper mapper;
            while ((mapper = mappers.lower(new ValidationMapper((String)currentPath, currentBinder, null, null))) != null && ((String)currentPath).startsWith(mapper.getValidationPath()) && (mapper.getBinder() == null || mapper.getBinder().equals(currentBinder))) {
                currentPath = mapper.getBindingPath() + ((String)currentPath).substring(mapper.getValidationPath().length());
                if (mapper.getNextBinder() != null) {
                    currentBinder = mapper.getNextBinder();
                }
                LOGGER.fine("{0}:{1} translated to {2}:{3}", binder.getInstanceNumber(), bindingPath, currentBinder.getInstanceNumber(), currentPath);
            }
        }
        return new MapResult(currentBinder, (String)currentPath);
    }

    public String format(Class<?> clazz, String pattern, Object ... args) {
        if (pattern != null) {
            if (clazz == null) {
                throw new ValidationRuntimeException("clazz is necessary to determine package");
            }
            String packageName = ReflectionHelper.getPackageName(clazz);
            if (packageName == null) {
                throw new IllegalArgumentException(clazz + " is not within a package");
            }
            while (true) {
                Class<?> bundleClass = null;
                try {
                    String bundleName = packageName + (packageName.isEmpty() ? "" : ".") + "ValidationBundle";
                    bundleClass = this.getValidationBundleClassLoader().loadClass(bundleName);
                    Method bundleMethod = bundleClass.getDeclaredMethod("getString", String.class);
                    if (!bundleMethod.getReturnType().equals(String.class)) {
                        throw new ValidationRuntimeException(bundleClass.getName() + "." + bundleMethod.getName() + " does not return a String");
                    }
                    if (!Modifier.isStatic(bundleMethod.getModifiers())) {
                        throw new ValidationRuntimeException(bundleClass.getName() + "." + bundleMethod.getName() + " is not static");
                    }
                    if (!Modifier.isPublic(bundleMethod.getModifiers())) {
                        throw new ValidationRuntimeException(bundleClass.getName() + "." + bundleMethod.getName() + " is not public");
                    }
                    try {
                        String localizedPattern = (String)bundleMethod.invoke(null, pattern);
                        return MessageFormat.format(localizedPattern, args);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        throw new ValidationRuntimeException("no localization for '" + pattern + "' in locale " + LocaleProvider.getInstance().getLocale(), ex);
                    }
                }
                catch (ClassNotFoundException e1) {
                    int ndx = packageName.lastIndexOf(46);
                    if (ndx > 0) {
                        packageName = packageName.substring(0, ndx);
                        continue;
                    }
                    if (packageName.isEmpty()) break;
                    packageName = "";
                    continue;
                }
                catch (NoSuchMethodException e2) {
                    throw new ValidationRuntimeException(bundleClass.getName() + " does not provide the method getString()");
                }
                break;
            }
            throw new ValidationRuntimeException("no ValidationBundle found for " + clazz);
        }
        return null;
    }

    public String format(Object object, String pattern, Object ... args) {
        Class<Object> clazz = object instanceof Class ? (Class<?>)object : (object instanceof EffectiveClassProvider ? ((EffectiveClassProvider)object).getEffectiveClass() : object.getClass());
        return this.format(clazz, pattern, args);
    }

    protected void sortValidatorsByPriority(List<Validator> validators) {
        validators.sort((o1, o2) -> {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getPriority() - o2.getPriority();
        });
    }

    protected String getAnnotatedElementName(AnnotatedElement element) {
        if (element instanceof Field) {
            return ((Field)element).getName();
        }
        if (element instanceof Method) {
            return StringHelper.firstToLower((String)ReflectionHelper.getPathMethodName((Method)element));
        }
        if (element instanceof Class) {
            return ((Class)element).getName();
        }
        throw new ValidationRuntimeException("cannot determine element name");
    }

    protected void extractValidators(Annotation annotation, AnnotatedElement element, List<Validator> validators, ValidationScope scope) {
        for (Annotation anno : annotation.annotationType().getAnnotations()) {
            if (anno instanceof Validation) {
                Validation validation = (Validation)anno;
                Class<? extends Validator> validatorClazz = validation.value();
                this.addValidator(annotation, element, -1, validators, scope, validatorClazz);
                continue;
            }
            if (!(anno instanceof RepeatableValidation)) continue;
            Class<? extends Annotation> repeatedAnnoClazz = ((RepeatableValidation)anno).value();
            Annotation[] repeatedAnnotations = element.getAnnotationsByType(repeatedAnnoClazz);
            int validationIndex = 0;
            for (Annotation repeatedAnno : repeatedAnnotations) {
                for (Annotation anno2 : repeatedAnno.annotationType().getAnnotations()) {
                    if (!(anno2 instanceof Validation)) continue;
                    Validation validation = (Validation)anno2;
                    Class<? extends Validator> validatorClazz = validation.value();
                    this.addValidator(repeatedAnno, element, validationIndex++, validators, scope, validatorClazz);
                }
            }
        }
    }

    protected void addValidator(Annotation annotation, AnnotatedElement element, int validationIndex, List<Validator> validators, ValidationScope scope, Class<? extends Validator> validatorClass) {
        try {
            Validator validator = validatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            validator.setAnnotation(annotation);
            validator.setAnnotatedElement(element);
            validator.setValidatedElementName(this.getAnnotatedElementName(element));
            validator.setValidationIndex(validationIndex);
            if (scope == null || scope.appliesTo(validator.getConfiguredScopes(null))) {
                validators.add(validator);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ValidationRuntimeException("could not create validator", ex);
        }
    }

    protected List<Validator> getElementValidators(AnnotatedElement element, ValidationScope scope) {
        ArrayList<Validator> validators = new ArrayList<Validator>();
        for (Annotation annotation : element.getAnnotations()) {
            this.extractValidators(annotation, element, validators, scope);
        }
        return validators;
    }

    private void logTest(Validator validator, ValidationContext validationContext) {
        LOGGER.log(this.testLogLevel, "applying " + validator + " to " + validationContext, null);
    }

    public static class ValidatorKey {
        private final String elementName;
        private final Class<?> validatorClass;
        private final int validationIndex;

        public ValidatorKey(Validator validator) {
            this.elementName = validator.getValidatedElementName();
            this.validatorClass = validator.getClass();
            this.validationIndex = validator.getValidationIndex();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValidatorKey other = (ValidatorKey)obj;
            if (this.elementName == null ? other.elementName != null : !this.elementName.equals(other.elementName)) {
                return false;
            }
            if (!(this.validatorClass == other.validatorClass || this.validatorClass != null && this.validatorClass.equals(other.validatorClass))) {
                return false;
            }
            return this.validationIndex == other.validationIndex;
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + (this.elementName != null ? this.elementName.hashCode() : 0);
            hash = 53 * hash + (this.validatorClass != null ? this.validatorClass.hashCode() : 0);
            hash = 53 * hash + this.validationIndex;
            return hash;
        }
    }

    public static class MapResult {
        private final Binder binder;
        private final String bindingPath;

        public MapResult(Binder binder, String bindingPath) {
            this.binder = binder;
            this.bindingPath = bindingPath;
        }

        public Binder getBinder() {
            return this.binder;
        }

        public String getBindingPath() {
            return this.bindingPath;
        }
    }
}

