/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.validate;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.Service;
import org.tentackle.validate.ValidationUtilities;
import org.tentackle.validate.Validator;
import org.tentackle.validate.ValidatorCacheHolder;

@Service(value=ValidatorCache.class)
public class ValidatorCache {
    private final Map<Class<?>, List<Validator>> fieldMap = new ConcurrentHashMap();
    private final Map<FieldMethodKey, List<Validator>> fieldMethodMap = new ConcurrentHashMap<FieldMethodKey, List<Validator>>();
    private final Map<Class<?>, List<Validator>> objectMap = new ConcurrentHashMap();

    public static ValidatorCache getInstance() {
        return ValidatorCacheHolder.INSTANCE;
    }

    public void invalidate() {
        this.fieldMap.clear();
        this.fieldMethodMap.clear();
        this.objectMap.clear();
    }

    public List<Validator> getFieldValidators(Class<?> clazz) {
        return this.fieldMap.computeIfAbsent(clazz, k -> ValidationUtilities.getInstance().getFieldValidators(clazz, null));
    }

    public List<Validator> getFieldValidators(Field field, Method method) {
        FieldMethodKey key = new FieldMethodKey(field, method);
        return this.fieldMethodMap.computeIfAbsent(key, k -> ValidationUtilities.getInstance().getFieldValidators(field, method, null));
    }

    public List<Validator> getObjectValidators(Class<?> clazz) {
        return this.objectMap.computeIfAbsent(clazz, k -> ValidationUtilities.getInstance().getObjectValidators(clazz, null));
    }

    private static class FieldMethodKey {
        private final Field field;
        private final Method method;

        private FieldMethodKey(Field field, Method method) {
            this.field = field;
            this.method = method;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldMethodKey other = (FieldMethodKey)obj;
            if (!(this.field == other.field || this.field != null && this.field.equals(other.field))) {
                return false;
            }
            return this.method == other.method || this.method != null && this.method.equals(other.method);
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + (this.field != null ? this.field.hashCode() : 0);
            hash = 29 * hash + (this.method != null ? this.method.hashCode() : 0);
            return hash;
        }
    }
}

